/*
 * Decompiled with CFR 0.152.
 */
package its_meow.claimit.api.util.objects;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import its_meow.claimit.api.permission.ClaimPermissionMember;
import its_meow.claimit.api.permission.ClaimPermissionRegistry;
import its_meow.claimit.api.util.objects.BiMultiMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public abstract class MemberContainer {
    protected BiMultiMap<ClaimPermissionMember, UUID> memberLists;
    protected UUID ownerUUID;

    public MemberContainer(UUID owner) {
        this.ownerUUID = owner;
        this.memberLists = new BiMultiMap();
    }

    public boolean addMember(UUID uuid, ClaimPermissionMember permission) {
        if (uuid.equals(this.ownerUUID)) {
            return false;
        }
        return this.memberLists.put(permission, uuid);
    }

    public boolean addMember(EntityPlayer player, ClaimPermissionMember permission) {
        return this.addMember(player.getGameProfile().getId(), permission);
    }

    public boolean removeMember(UUID uuid, ClaimPermissionMember permission) {
        if (uuid.equals(this.ownerUUID)) {
            return false;
        }
        return this.memberLists.remove(permission, uuid);
    }

    public boolean removeMember(EntityPlayer player, ClaimPermissionMember permission) {
        return this.removeMember(player.getGameProfile().getId(), permission);
    }

    public abstract boolean hasPermission(UUID var1, ClaimPermissionMember var2);

    public boolean hasPermission(EntityPlayer player, ClaimPermissionMember permission) {
        return this.hasPermission(player.getGameProfile().getId(), permission);
    }

    public boolean isOwner(EntityPlayer player) {
        return this.isOwner(player.getGameProfile().getId());
    }

    public boolean isOwner(UUID uuid) {
        return this.ownerUUID.equals(uuid);
    }

    public UUID getOwner() {
        return this.ownerUUID;
    }

    protected void addMembers(SetMultimap<ClaimPermissionMember, UUID> memberLists) {
        for (ClaimPermissionMember key : memberLists.keySet()) {
            this.memberLists.putAll(key, memberLists.get((Object)key));
        }
    }

    public boolean inPermissionList(ClaimPermissionMember permission, UUID id) {
        Set<UUID> members = this.memberLists.getValues(permission);
        return members != null && members.contains(id);
    }

    public ImmutableSetMultimap<UUID, ClaimPermissionMember> getMembers() {
        return this.memberLists.getValuesToKeys();
    }

    public static SetMultimap<ClaimPermissionMember, UUID> readMembers(NBTTagCompound tag) {
        SetMultimap map = MultimapBuilder.hashKeys().hashSetValues().build();
        NBTTagCompound memberCompound = tag.getCompoundTag("MEMBERS");
        for (String permString : memberCompound.getKeySet()) {
            if (ClaimPermissionRegistry.getPermissionMember(permString) == null) continue;
            NBTTagList tagList = memberCompound.getTagList(permString, 8);
            ClaimPermissionMember perm = ClaimPermissionRegistry.getPermissionMember(permString);
            for (int i = 0; i < tagList.tagCount(); ++i) {
                String uuidString = tagList.getStringTagAt(i);
                UUID member = UUID.fromString(uuidString);
                map.put((Object)perm, (Object)member);
            }
        }
        return map;
    }

    public NBTTagCompound writeMembers(NBTTagCompound tag) {
        NBTTagCompound memberCompound = new NBTTagCompound();
        for (ClaimPermissionMember perm : this.memberLists.getKeysToValues().keySet()) {
            NBTTagList members = new NBTTagList();
            for (UUID member : this.memberLists.getKeysToValues().get((Object)perm)) {
                members.appendTag((NBTBase)new NBTTagString(member.toString()));
            }
            memberCompound.setTag(perm.parsedName, (NBTBase)members);
        }
        tag.setTag("MEMBERS", (NBTBase)memberCompound);
        return tag;
    }
}

