(ns fogus.thneed.utils)

(defn keys-apply [f ks m]
  "Takes a function, a set of keys, and a map and applies
   the function to the map on the given keys.  A new map of
   the results of the function applied to the keyed entries
   is returned."
  (let [only (select-keys m ks)]
    (zipmap (keys only) (map f (vals only)))))

(defn manip-map [f ks m]
  "Takes a function, a set of keys, and a map and applies the function 
   to the map on the given keys.  A modified version of the original map
   is returned with the results of the function applied to each keyed entry."
  (conj m (keys-apply f ks m)))

(defn str->kw [s]
  {:pre  [(string? s) (re-matches #"Billy" s)]
   :post [(keyword? %)]}
  (keyword s))


(defn pack [coll]
  (letfn [(pack* [[f & r :as S] acc]
            (when (seq S)
              (let [[packed tail] (split-with #{f} S)]
                (if (seq tail)
                  (recur tail (conj acc packed))
                  (conj acc packed)))))]
    (pack* coll [])))

(defn rle [coll]
  (map #(vector (count %) (first %))
       (pack (seq coll))))

(comment
  (def S ['a, 'a, 'a, 'a, 'b, 'c, 'c, 'a, 'a, 'd, 'e, 'e, 'e, 'e])
  (pack S)
  (rld (pack S))

  (println (rle S))
  )

(defmacro !! [& ks]
  `(let [keys# (quote ~ks)
         keys# (map keyword keys#)
         vals# (list ~@ ks)]
     (zipmap keys# vals#)))

(defmacro time-expr
  [expr msg & more]
  `(let [start# (. System (nanoTime))
         ret# ~expr
         elapsed# (/ (double (- (. System (nanoTime)) start#)) 1000000.0)]
     (println (apply format ~msg elapsed# ret# ~(vec more)))
     ret#))

(comment
  (time-expr (+ 1 2 3)
             "time(%f) gets %d with %s and %s"
             "foo"
             (- 2 3 43 5 67))
)

(defn sleepy
  [e t]
  (Thread/sleep t) e)