/*
 * Decompiled with CFR 0.152.
 */
package isdigital.errorhandler;

import isdigital.errorhandler.ActionEntry;
import isdigital.errorhandler.ExceptionMatcher;
import isdigital.errorhandler.Matcher;
import isdigital.errorhandler.MatcherFactory;
import isdigital.errorhandler.UnknownErrorCodeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 42\u00020\u0001:\u0003456B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0015\u001a\u00020\u00002\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fJ=\u0010\u0017\u001a\u00020\u0000\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u0002H\u00182\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u0002H\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u001b0\u001b\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u0017\u001a\u00020\u0000\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u0002H\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0010\u00a2\u0006\u0002\u0010\u001eJ>\u0010\u001f\u001a\u00020\u0000\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00180!2\u001e\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u0002H\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u001b0\u001bJ,\u0010\u001f\u001a\u00020\u0000\"\b\b\u0000\u0010\u0018*\u00020\u00012\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00180!2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0010J\u0006\u0010\"\u001a\u00020\u000bJ'\u0010#\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u0010\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u0002H\u0018H\u0004\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\nJ\u001e\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J8\u0010(\u001a\u00020\u00002\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u001b2\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fJ;\u0010(\u001a\u00020\u0000\"\b\b\u0000\u0010\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u0002H\u00182\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f\u00a2\u0006\u0002\u0010*J,\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020+2\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fJ4\u0010(\u001a\u00020\u00002\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0!2\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fJ$\u0010-\u001a\u00020\u00002\u001c\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fJ\u0014\u0010.\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b00J\u0006\u00101\u001a\u00020\u0000J\u0006\u00102\u001a\u00020\u0000J\u0006\u00103\u001a\u00020\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lisdigital/errorhandler/ErrorHandler;", "", "parentErrorHandler", "(Lisdigital/errorhandler/ErrorHandler;)V", "()V", "actions", "", "Lisdigital/errorhandler/ActionEntry;", "alwaysActions", "Lkotlin/Function2;", "", "", "Lisdigital/errorhandler/Action;", "errorCodeMap", "", "Lisdigital/errorhandler/ErrorHandler$ErrorCodeIdentifier;", "Lisdigital/errorhandler/MatcherFactory;", "localContext", "Ljava/lang/ThreadLocal;", "Lisdigital/errorhandler/ErrorHandler$Context;", "otherwiseActions", "always", "action", "bind", "T", "errorCode", "matcherFactory", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lisdigital/errorhandler/ErrorHandler;", "(Ljava/lang/Object;Lisdigital/errorhandler/MatcherFactory;)Lisdigital/errorhandler/ErrorHandler;", "bindClass", "errorCodeClass", "Lkotlin/reflect/KClass;", "clear", "getMatcherFactoryForErrorCode", "(Ljava/lang/Object;)Lisdigital/errorhandler/MatcherFactory;", "handle", "error", "context", "on", "matcher", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Lisdigital/errorhandler/ErrorHandler;", "Lisdigital/errorhandler/Matcher;", "exceptionClass", "otherwise", "runHandling", "closure", "Lkotlin/Function0;", "skipAlways", "skipDefaults", "skipFollowing", "Companion", "Context", "ErrorCodeIdentifier", "errorhandler"})
public final class ErrorHandler {
    private final Map<ErrorCodeIdentifier<?>, MatcherFactory<?>> errorCodeMap;
    private final List<ActionEntry> actions;
    private final List<Function2<Throwable, ErrorHandler, Unit>> otherwiseActions;
    private final List<Function2<Throwable, ErrorHandler, Unit>> alwaysActions;
    private ThreadLocal<Context> localContext;
    private ErrorHandler parentErrorHandler;
    private static ErrorHandler defaultInstance;
    public static final Companion Companion;

    @NotNull
    public final ErrorHandler on(@NotNull Matcher matcher, @NotNull Function2<? super Throwable, ? super ErrorHandler, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.actions.add(new ActionEntry(matcher, action));
        return this;
    }

    @NotNull
    public final ErrorHandler on(@NotNull Function1<? super Throwable, Boolean> matcher, @NotNull Function2<? super Throwable, ? super ErrorHandler, Unit> action) {
        Intrinsics.checkParameterIsNotNull(matcher, (String)"matcher");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return this.on((Object)new Matcher(matcher){
            final /* synthetic */ Function1 $matcher;

            public boolean matches(@NotNull Throwable throwable) {
                Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                return (Boolean)this.$matcher.invoke((Object)throwable);
            }
            {
                this.$matcher = $captured_local_variable$0;
            }
        }, action);
    }

    @NotNull
    public final ErrorHandler on(@NotNull KClass<? extends Throwable> exceptionClass, @NotNull Function2<? super Throwable, ? super ErrorHandler, Unit> action) {
        Intrinsics.checkParameterIsNotNull(exceptionClass, (String)"exceptionClass");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.actions.add(new ActionEntry(new ExceptionMatcher(exceptionClass), action));
        return this;
    }

    @NotNull
    public final <T> ErrorHandler on(@NotNull T errorCode, @NotNull Function2<? super Throwable, ? super ErrorHandler, Unit> action) {
        Intrinsics.checkParameterIsNotNull(errorCode, (String)"errorCode");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        MatcherFactory<T> matcherFactory = this.getMatcherFactoryForErrorCode(errorCode);
        if (matcherFactory == null) {
            throw (Throwable)new UnknownErrorCodeException(errorCode);
        }
        MatcherFactory<T> matcherFactory2 = matcherFactory;
        this.actions.add(new ActionEntry(matcherFactory2.build(errorCode), action));
        return this;
    }

    @NotNull
    public final ErrorHandler otherwise(@NotNull Function2<? super Throwable, ? super ErrorHandler, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.otherwiseActions.add(action);
        return this;
    }

    @NotNull
    public final ErrorHandler always(@NotNull Function2<? super Throwable, ? super ErrorHandler, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.alwaysActions.add(action);
        return this;
    }

    @NotNull
    public final ErrorHandler skipFollowing() {
        this.localContext.get().setSkipFollowing(true);
        return this;
    }

    @NotNull
    public final ErrorHandler skipAlways() {
        this.localContext.get().setSkipAlways(true);
        return this;
    }

    @NotNull
    public final ErrorHandler skipDefaults() {
        this.localContext.get().setSkipDefaults(true);
        return this;
    }

    private final void handle(Throwable error, ThreadLocal<Context> context) {
        block7: {
            this.localContext = context;
            Context ctx = this.localContext.get();
            for (ActionEntry actionEntry : this.actions) {
                if (ctx.getSkipFollowing()) break;
                if (!actionEntry.getMatcher().matches(error)) continue;
                actionEntry.getAction().invoke((Object)error, (Object)this);
                ctx.setHandled(true);
            }
            if (!ctx.getHandled()) {
                Collection collection = this.otherwiseActions;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    for (Function2<Throwable, ErrorHandler, Unit> function2 : this.otherwiseActions) {
                        function2.invoke((Object)error, (Object)this);
                        ctx.setHandled(true);
                    }
                }
            }
            if (!ctx.getSkipAlways()) {
                for (Function2 function2 : this.alwaysActions) {
                    function2.invoke((Object)error, (Object)this);
                    ctx.setHandled(true);
                }
            }
            if (ctx.getSkipDefaults()) break block7;
            ErrorHandler errorHandler2 = this.parentErrorHandler;
            if (errorHandler2 != null) {
                errorHandler2.handle(error, this.localContext);
            }
        }
    }

    public final void runHandling(@NotNull Function0<Unit> closure) {
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        try {
            closure.invoke();
        }
        catch (Throwable throwable) {
            this.handle(throwable, this.localContext);
        }
    }

    public final void handle(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this.handle(error, this.localContext);
    }

    @NotNull
    public final <T> ErrorHandler bind(@NotNull T errorCode, @NotNull MatcherFactory<? super T> matcherFactory) {
        Intrinsics.checkParameterIsNotNull(errorCode, (String)"errorCode");
        Intrinsics.checkParameterIsNotNull(matcherFactory, (String)"matcherFactory");
        this.errorCodeMap.put(new ErrorCodeIdentifier<T>(errorCode), matcherFactory);
        return this;
    }

    @NotNull
    public final <T> ErrorHandler bind(@NotNull T errorCode, @NotNull Function1<? super T, ? extends Function1<? super Throwable, Boolean>> matcherFactory) {
        Intrinsics.checkParameterIsNotNull(errorCode, (String)"errorCode");
        Intrinsics.checkParameterIsNotNull(matcherFactory, (String)"matcherFactory");
        return this.bind(errorCode, new MatcherFactory<T>(matcherFactory){
            final /* synthetic */ Function1 $matcherFactory;

            @NotNull
            public Matcher build(@NotNull T errorCode) {
                Intrinsics.checkParameterIsNotNull(errorCode, (String)"errorCode");
                Function1 matcher = (Function1)this.$matcherFactory.invoke(errorCode);
                return new Matcher(matcher){
                    final /* synthetic */ Function1 $matcher;

                    public boolean matches(@NotNull Throwable throwable) {
                        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                        return (Boolean)this.$matcher.invoke((Object)throwable);
                    }
                    {
                        this.$matcher = $captured_local_variable$0;
                    }
                };
            }
            {
                this.$matcherFactory = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final <T> ErrorHandler bindClass(@NotNull KClass<T> errorCodeClass, @NotNull MatcherFactory<? super T> matcherFactory) {
        Intrinsics.checkParameterIsNotNull(errorCodeClass, (String)"errorCodeClass");
        Intrinsics.checkParameterIsNotNull(matcherFactory, (String)"matcherFactory");
        this.errorCodeMap.put(new ErrorCodeIdentifier<T>(errorCodeClass), matcherFactory);
        return this;
    }

    @NotNull
    public final <T> ErrorHandler bindClass(@NotNull KClass<T> errorCodeClass, @NotNull Function1<? super T, ? extends Function1<? super Throwable, Boolean>> matcherFactory) {
        Intrinsics.checkParameterIsNotNull(errorCodeClass, (String)"errorCodeClass");
        Intrinsics.checkParameterIsNotNull(matcherFactory, (String)"matcherFactory");
        return this.bindClass(errorCodeClass, new MatcherFactory<T>(matcherFactory){
            final /* synthetic */ Function1 $matcherFactory;

            @NotNull
            public Matcher build(@NotNull T errorCode) {
                Intrinsics.checkParameterIsNotNull(errorCode, (String)"errorCode");
                Function1 matcher = (Function1)this.$matcherFactory.invoke(errorCode);
                return new Matcher(matcher){
                    final /* synthetic */ Function1 $matcher;

                    public boolean matches(@NotNull Throwable throwable) {
                        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                        return (Boolean)this.$matcher.invoke((Object)throwable);
                    }
                    {
                        this.$matcher = $captured_local_variable$0;
                    }
                };
            }
            {
                this.$matcherFactory = $captured_local_variable$0;
            }
        });
    }

    @Nullable
    protected final <T> MatcherFactory<T> getMatcherFactoryForErrorCode(@NotNull T errorCode) {
        MatcherFactory<T> matcherFactory;
        Intrinsics.checkParameterIsNotNull(errorCode, (String)"errorCode");
        MatcherFactory<?> matcherFactory2 = null;
        MatcherFactory<?> matcherFactory3 = this.errorCodeMap.get(new ErrorCodeIdentifier<T>(errorCode));
        if (!(matcherFactory3 instanceof MatcherFactory)) {
            matcherFactory3 = null;
        }
        if ((matcherFactory2 = matcherFactory3) != null) {
            return matcherFactory2;
        }
        MatcherFactory<?> matcherFactory4 = this.errorCodeMap.get(new ErrorCodeIdentifier(Reflection.getOrCreateKotlinClass(errorCode.getClass())));
        if (!(matcherFactory4 instanceof MatcherFactory)) {
            matcherFactory4 = null;
        }
        if ((matcherFactory2 = matcherFactory4) != null) {
            return matcherFactory2;
        }
        if (this.parentErrorHandler != null) {
            ErrorHandler errorHandler2 = this.parentErrorHandler;
            matcherFactory = errorHandler2 != null ? errorHandler2.getMatcherFactoryForErrorCode(errorCode) : null;
        } else {
            matcherFactory = null;
        }
        return matcherFactory;
    }

    public final void clear() {
        this.actions.clear();
        this.errorCodeMap.clear();
        this.otherwiseActions.clear();
        this.alwaysActions.clear();
        this.localContext.get().clear();
    }

    private ErrorHandler() {
        ErrorHandler errorHandler2 = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        errorHandler2.errorCodeMap = object;
        errorHandler2 = this;
        bl = false;
        errorHandler2.actions = object = (List)new ArrayList();
        errorHandler2 = this;
        bl = false;
        errorHandler2.otherwiseActions = object = (List)new ArrayList();
        errorHandler2 = this;
        bl = false;
        errorHandler2.alwaysActions = object = (List)new ArrayList();
        this.localContext = new ThreadLocal<Context>(){

            @NotNull
            protected Context initialValue() {
                return new Context();
            }
        };
    }

    private ErrorHandler(ErrorHandler parentErrorHandler) {
        this();
        this.parentErrorHandler = parentErrorHandler;
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ ErrorHandler(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public /* synthetic */ ErrorHandler(ErrorHandler parentErrorHandler, DefaultConstructorMarker $constructor_marker) {
        this(parentErrorHandler);
    }

    @JvmStatic
    @NotNull
    public static final ErrorHandler createIsolated() {
        return Companion.createIsolated();
    }

    @JvmStatic
    @NotNull
    public static final ErrorHandler create(@Nullable ErrorHandler parentErrorHandler) {
        return Companion.create(parentErrorHandler);
    }

    @JvmStatic
    @NotNull
    public static final synchronized ErrorHandler defaultErrorHandler() {
        return Companion.defaultErrorHandler();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0086\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0001J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u001c"}, d2={"Lisdigital/errorhandler/ErrorHandler$Context;", "", "()V", "handled", "", "getHandled", "()Z", "setHandled", "(Z)V", "keys", "Ljava/util/HashMap;", "", "skipAlways", "getSkipAlways", "setSkipAlways", "skipDefaults", "getSkipDefaults", "setSkipDefaults", "skipFollowing", "getSkipFollowing", "setSkipFollowing", "clear", "", "get", "key", "put", "value", "remove", "errorhandler"})
    private static final class Context {
        private final HashMap<String, Object> keys = new HashMap();
        private boolean handled;
        private boolean skipDefaults;
        private boolean skipFollowing;
        private boolean skipAlways;

        public final boolean getHandled() {
            return this.handled;
        }

        public final void setHandled(boolean bl) {
            this.handled = bl;
        }

        public final boolean getSkipDefaults() {
            return this.skipDefaults;
        }

        public final void setSkipDefaults(boolean bl) {
            this.skipDefaults = bl;
        }

        public final boolean getSkipFollowing() {
            return this.skipFollowing;
        }

        public final void setSkipFollowing(boolean bl) {
            this.skipFollowing = bl;
        }

        public final boolean getSkipAlways() {
            return this.skipAlways;
        }

        public final void setSkipAlways(boolean bl) {
            this.skipAlways = bl;
        }

        @Nullable
        public final Object get(@Nullable Object key) {
            Map map = this.keys;
            boolean bl = false;
            return map.get(key);
        }

        @Nullable
        public final Object put(@NotNull String key, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return this.keys.put(key, value);
        }

        @Nullable
        public final Object remove(@Nullable Object key) {
            Map map = this.keys;
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            return TypeIntrinsics.asMutableMap((Object)map2).remove(key);
        }

        public final void clear() {
            this.keys.clear();
            this.skipDefaults = false;
            this.skipFollowing = false;
            this.skipAlways = false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0010\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0018\u0010\u0005\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lisdigital/errorhandler/ErrorHandler$ErrorCodeIdentifier;", "T", "", "errorCode", "(Ljava/lang/Object;)V", "errorCodeClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "errorhandler"})
    private static final class ErrorCodeIdentifier<T> {
        private final T errorCode;
        private final KClass<? extends T> errorCodeClass;

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
                return false;
            }
            ErrorCodeIdentifier that = (ErrorCodeIdentifier)other;
            if (this.errorCode != null ? Intrinsics.areEqual(this.errorCode, that.errorCode) ^ true : that.errorCode != null) {
                return false;
            }
            return this.errorCodeClass != null ? Intrinsics.areEqual(this.errorCodeClass, that.errorCodeClass) : that.errorCodeClass == null;
        }

        public int hashCode() {
            T t = this.errorCode;
            int result = t != null ? t.hashCode() : 0;
            KClass<? extends T> kClass = this.errorCodeClass;
            result = 31 * result + (kClass != null ? kClass.hashCode() : 0);
            return result;
        }

        public ErrorCodeIdentifier(@NotNull T errorCode) {
            Intrinsics.checkParameterIsNotNull(errorCode, (String)"errorCode");
            this.errorCode = errorCode;
            this.errorCodeClass = null;
        }

        public ErrorCodeIdentifier(@NotNull KClass<? extends T> errorCodeClass) {
            Intrinsics.checkParameterIsNotNull(errorCodeClass, (String)"errorCodeClass");
            this.errorCode = null;
            this.errorCodeClass = errorCodeClass;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lisdigital/errorhandler/ErrorHandler$Companion;", "", "()V", "defaultInstance", "Lisdigital/errorhandler/ErrorHandler;", "create", "parentErrorHandler", "createIsolated", "defaultErrorHandler", "errorhandler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ErrorHandler createIsolated() {
            return new ErrorHandler(null);
        }

        @JvmStatic
        @NotNull
        public final ErrorHandler create(@Nullable ErrorHandler parentErrorHandler) {
            ErrorHandler errorHandler2 = parentErrorHandler;
            if (errorHandler2 == null) {
                errorHandler2 = this.defaultErrorHandler();
            }
            return new ErrorHandler(errorHandler2, null);
        }

        public static /* synthetic */ ErrorHandler create$default(Companion companion, ErrorHandler errorHandler2, int n, Object object) {
            if ((n & 1) != 0) {
                errorHandler2 = null;
            }
            return companion.create(errorHandler2);
        }

        @JvmStatic
        @NotNull
        public final synchronized ErrorHandler defaultErrorHandler() {
            if (defaultInstance == null) {
                defaultInstance = new ErrorHandler(null);
            }
            ErrorHandler errorHandler2 = defaultInstance;
            if (errorHandler2 == null) {
                Intrinsics.throwNpe();
            }
            return errorHandler2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

