/*
 * Decompiled with CFR 0.152.
 */
package io.zksync.sdk.zkscrypto.lib;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import io.zksync.sdk.zkscrypto.lib.ZksCryptoNative;
import io.zksync.sdk.zkscrypto.lib.entity.ZksPackedPublicKey;
import io.zksync.sdk.zkscrypto.lib.entity.ZksPrivateKey;
import io.zksync.sdk.zkscrypto.lib.entity.ZksPubkeyHash;
import io.zksync.sdk.zkscrypto.lib.entity.ZksRescueHashOrders;
import io.zksync.sdk.zkscrypto.lib.entity.ZksSignature;
import io.zksync.sdk.zkscrypto.lib.exception.ZksMusigTooLongException;
import io.zksync.sdk.zkscrypto.lib.exception.ZksSeedTooShortException;
import java.io.IOException;
import org.scijava.nativelib.BaseJniExtractor;
import org.scijava.nativelib.NativeLoader;

public final class ZksCrypto {
    private static final String LIBRARY_NAME = "zks_crypto";
    private ZksCryptoNative crypto;

    private ZksCrypto() {
    }

    public static ZksCrypto load() {
        ZksCrypto crypto = new ZksCrypto();
        crypto.crypto = (ZksCryptoNative)Native.load((String)LIBRARY_NAME, ZksCryptoNative.class);
        crypto.crypto.zks_crypto_init();
        return crypto;
    }

    public ZksPrivateKey generatePrivateKey(byte[] seed) throws ZksSeedTooShortException {
        ZksPrivateKey.ByReference privateKey = new ZksPrivateKey.ByReference();
        int resultCode = this.crypto.zks_crypto_private_key_from_seed(seed, seed.length, privateKey);
        switch (ZksPrivateKey.ResultCode.fromCode(resultCode)) {
            case SUCCESS: {
                return privateKey;
            }
            case SEED_TOO_SHORT: {
                throw new ZksSeedTooShortException("Given seed is too short, length must be greater than 32");
            }
        }
        throw new UnsupportedOperationException();
    }

    public ZksPackedPublicKey getPublicKey(ZksPrivateKey privateKey) {
        ZksPackedPublicKey.ByReference publicKey = new ZksPackedPublicKey.ByReference();
        int resultCode = this.crypto.zks_crypto_private_key_to_public_key((ZksPrivateKey.ByReference)privateKey, publicKey);
        if (ZksPackedPublicKey.ResultCode.fromCode(resultCode) == ZksPackedPublicKey.ResultCode.SUCCESS) {
            return publicKey;
        }
        throw new UnsupportedOperationException();
    }

    public ZksPubkeyHash getPublicKeyHash(ZksPackedPublicKey publicKey) {
        ZksPubkeyHash.ByReference pubkeyHash = new ZksPubkeyHash.ByReference();
        int resultCode = this.crypto.zks_crypto_public_key_to_pubkey_hash((ZksPackedPublicKey.ByReference)publicKey, pubkeyHash);
        if (ZksPubkeyHash.ResultCode.fromCode(resultCode) == ZksPubkeyHash.ResultCode.SUCCESS) {
            return pubkeyHash;
        }
        throw new UnsupportedOperationException();
    }

    public ZksSignature signMessage(ZksPrivateKey privateKey, byte[] message) throws ZksMusigTooLongException {
        ZksSignature.ByReference signature = new ZksSignature.ByReference();
        int resultCode = this.crypto.zks_crypto_sign_musig((ZksPrivateKey.ByReference)privateKey, message, message.length, signature);
        switch (ZksSignature.ResultCode.fromCode(resultCode)) {
            case SUCCESS: {
                return signature;
            }
            case MUSIG_MESSAGE_TOO_LONG: {
                throw new ZksMusigTooLongException("Musig message is too long");
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean verifySignature(ZksPackedPublicKey publicKey, ZksSignature signature, byte[] message) {
        int resultCode = this.crypto.zks_crypto_verify_musig(message, message.length, (ZksPackedPublicKey.ByReference)publicKey, (ZksSignature.ByReference)signature);
        return resultCode == 0;
    }

    public ZksRescueHashOrders rescueHashOrders(byte[] orders) {
        ZksRescueHashOrders.ByReference result = new ZksRescueHashOrders.ByReference();
        this.crypto.rescue_hash_orders(orders, orders.length, result);
        return result;
    }

    static {
        try {
            NativeLoader.loadLibrary((String)LIBRARY_NAME, (String[])new String[0]);
            NativeLibrary.addSearchPath((String)LIBRARY_NAME, (String)((BaseJniExtractor)NativeLoader.getJniExtractor()).getJniDir().getAbsolutePath());
            NativeLibrary.addSearchPath((String)LIBRARY_NAME, (String)((BaseJniExtractor)NativeLoader.getJniExtractor()).getNativeDir().getAbsolutePath());
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot load native library", e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

