/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package io.zksync.sdk.zkscrypto.example;

import io.zksync.sdk.zkscrypto.lib.ZksCrypto;
import io.zksync.sdk.zkscrypto.lib.entity.ZksPackedPublicKey;
import io.zksync.sdk.zkscrypto.lib.entity.ZksPrivateKey;
import io.zksync.sdk.zkscrypto.lib.entity.ZksPubkeyHash;
import io.zksync.sdk.zkscrypto.lib.entity.ZksSignature;
import io.zksync.sdk.zkscrypto.lib.exception.ZksMusigTooLongException;
import io.zksync.sdk.zkscrypto.lib.exception.ZksSeedTooShortException;

import org.web3j.utils.Numeric;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class App {

    public static void main(String[] args) {
        ZksCrypto crypto = ZksCrypto.load();

        byte[] seed = Arrays.copyOf(new byte[0], 32);
        byte[] msg = "hello".getBytes(StandardCharsets.UTF_8);

        try {
            ZksPrivateKey privateKey = crypto.generatePrivateKey(seed);
            ZksPackedPublicKey publicKey = crypto.getPublicKey(privateKey);
            ZksPubkeyHash pubkeyHash = crypto.getPublicKeyHash(publicKey);
            ZksSignature signature = crypto.signMessage(privateKey, msg);
            System.out.printf("Seed: %s\n", Numeric.toHexString(seed));
            System.out.printf("Private key: %s\n", Numeric.toHexString(privateKey.getData()));
            System.out.printf("Public key: %s\n", Numeric.toHexString(publicKey.getData()));
            System.out.printf("Public key hash: %s\n", Numeric.toHexString(pubkeyHash.getData()));
            System.out.printf("Signature: %s\n", Numeric.toHexString(signature.getData()));

            boolean verified = crypto.verifySignature(publicKey, signature, msg);

            if (verified) {
                System.out.println("Signature verified");
            } else {
                System.out.println("Signature verification failed");
            }
        } catch (ZksSeedTooShortException | ZksMusigTooLongException e) {
            System.err.println(e);
        }
    }

}
