/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.internal.Nullable;
import brave.internal.Throwables;
import brave.jms.JmsTracing;
import brave.jms.MessageParser;
import brave.messaging.ProducerRequest;
import brave.propagation.Propagation;
import javax.jms.Destination;
import javax.jms.JMSProducer;

final class JMSProducerRequest
extends ProducerRequest {
    static final Propagation.RemoteGetter<JMSProducerRequest> GETTER = new Propagation.RemoteGetter<JMSProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public String get(JMSProducerRequest request, String name) {
            return request.getStringProperty(name);
        }

        public String toString() {
            return "JMSProducer::getStringProperty";
        }
    };
    static final Propagation.RemoteSetter<JMSProducerRequest> SETTER = new Propagation.RemoteSetter<JMSProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public void put(JMSProducerRequest request, String name, String value) {
            request.setProperty(name, value);
        }

        public String toString() {
            return "JMSProducer::setProperty";
        }
    };
    final JMSProducer delegate;
    @Nullable
    final Destination destination;

    JMSProducerRequest(JMSProducer delegate, @Nullable Destination destination) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
        this.destination = destination;
    }

    public Span.Kind spanKind() {
        return Span.Kind.PRODUCER;
    }

    public Object unwrap() {
        return this.delegate;
    }

    public String operation() {
        return "send";
    }

    public String channelKind() {
        return MessageParser.channelKind(this.destination);
    }

    public String channelName() {
        return MessageParser.channelName(this.destination);
    }

    @Nullable
    String getStringProperty(String name) {
        try {
            return this.delegate.getStringProperty(name);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error getting property {0} from producer {1}", name, this.delegate);
            return null;
        }
    }

    void setProperty(String name, String value) {
        try {
            this.delegate.setProperty(name, value);
        }
        catch (Throwable t) {
            Throwables.propagateIfFatal((Throwable)t);
            JmsTracing.log(t, "error setting property {0} on producer {1}", name, this.delegate);
        }
    }
}

