/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.httpclient.TracingMainExec;
import brave.httpclient.TracingProtocolExec;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;

public final class TracingCachingHttpClientBuilder
extends CachingHttpClientBuilder {
    final HttpTracing httpTracing;

    public static CachingHttpClientBuilder create(Tracing tracing) {
        return new TracingCachingHttpClientBuilder(HttpTracing.create((Tracing)tracing));
    }

    public static CachingHttpClientBuilder create(HttpTracing httpTracing) {
        return new TracingCachingHttpClientBuilder(httpTracing);
    }

    TracingCachingHttpClientBuilder(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        this.httpTracing = httpTracing;
    }

    protected ClientExecChain decorateProtocolExec(ClientExecChain protocolExec) {
        return new TracingProtocolExec(this.httpTracing, protocolExec);
    }

    protected ClientExecChain decorateMainExec(ClientExecChain exec) {
        return new TracingMainExec(this.httpTracing, exec);
    }
}

