/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.spring.cloud.config.client;

import io.zhudy.duic.spring.cloud.config.client.ConfigClientProperties;
import io.zhudy.duic.spring.cloud.config.client.RestTemplateUtils;
import io.zhudy.duic.spring.cloud.config.environment.State;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class ConfigWatchService
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(ConfigWatchService.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ContextRefresher refresher;
    private Environment environment;
    private ConfigurableListableBeanFactory beanFactory;
    private ConfigClientProperties properties;

    public ConfigWatchService(ContextRefresher refresher, Environment environment, ConfigurableListableBeanFactory beanFactory, ConfigClientProperties clientProperties) {
        this.refresher = refresher;
        this.environment = environment;
        this.beanFactory = beanFactory;
        this.properties = clientProperties;
    }

    @PostConstruct
    public void start() {
        this.running.compareAndSet(false, true);
        Thread t = new Thread("duic-watch-config-state"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ConfigWatchService.this.watch();
                        }
                    }
                    catch (Exception e) {
                        log.error("\u76d1\u63a7\u914d\u7f6e\u72b6\u6001\u5f02\u5e38", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private void watch() {
        if (this.running.get()) {
            String state = this.environment.getProperty("config.client.state");
            String remoteState = this.watchState(state);
            if (remoteState == null) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (remoteState != null && !remoteState.equals(state)) {
                log.info("Reloading config: name={}, profiles={}, state={}, remoteState={}", new Object[]{this.properties.getName(), this.properties.getProfile(), state, remoteState});
                this.refresher.refresh();
                AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
                bpp.setAutowiredAnnotationType(Value.class);
                bpp.setBeanFactory((BeanFactory)this.beanFactory);
                for (String name : this.beanFactory.getBeanDefinitionNames()) {
                    bpp.processInjection(this.beanFactory.getBean(name));
                }
            }
        }
    }

    private String watchState(String state) {
        String token = this.properties.getToken();
        String name = this.properties.getName();
        String profile = this.properties.getProfile();
        String url = this.properties.getUri() + "/apps/watches/" + name + "/" + profile + "?state=" + state;
        ResponseEntity response = null;
        try {
            HttpHeaders headers = new HttpHeaders();
            if (StringUtils.hasText((String)token)) {
                headers.add("x-config-token", token);
            }
            headers.add("Connection", "keep-alive");
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            RestTemplate restTemplate = RestTemplateUtils.getRestTemplate(this.properties);
            log.debug("Checking config state from server at: {} {}", (Object)url);
            response = restTemplate.exchange(url, HttpMethod.GET, entity, State.class, new Object[0]);
        }
        catch (Exception e) {
            log.warn("Checking config state failed: {}", (Throwable)e);
        }
        if (response == null || response.getStatusCode() != HttpStatus.OK) {
            return null;
        }
        State result = (State)response.getBody();
        return result.getState();
    }

    @Override
    public void close() throws IOException {
        this.running.compareAndSet(true, false);
    }
}

