/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.spring.cloud.config.client;

import io.zhudy.duic.spring.cloud.config.client.ConfigClientProperties;
import io.zhudy.duic.spring.cloud.config.client.RestTemplateUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Order(value=0)
public class ConfigServicePropertySourceLocator
implements PropertySourceLocator {
    private static Logger log = LoggerFactory.getLogger(ConfigServicePropertySourceLocator.class);
    private ConfigClientProperties defaultProperties;

    public ConfigServicePropertySourceLocator(ConfigClientProperties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public PropertySource<?> locate(Environment environment) {
        ConfigClientProperties properties = this.defaultProperties.override(environment);
        CompositePropertySource composite = new CompositePropertySource("configService");
        Throwable error = null;
        String errorBody = null;
        try {
            io.zhudy.duic.spring.cloud.config.environment.Environment result = this.getRemoteEnvironment(properties);
            if (result != null) {
                log.info("Located environment: name={}, profiles={}, state={}", new Object[]{result.getName(), Arrays.asList(result.getProfiles()), result.getState()});
                if (result.getPropertySources() != null) {
                    for (io.zhudy.duic.spring.cloud.config.environment.PropertySource source : result.getPropertySources()) {
                        Map<?, ?> map = source.getSource();
                        composite.addPropertySource((PropertySource)new MapPropertySource(source.getName(), map));
                    }
                }
                if (StringUtils.hasText((String)result.getState())) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("config.client.state", result.getState());
                    composite.addFirstPropertySource((PropertySource)new MapPropertySource("configClient", map));
                }
                return composite;
            }
        }
        catch (HttpServerErrorException e) {
            error = e;
            if (MediaType.APPLICATION_JSON.includes(e.getResponseHeaders().getContentType())) {
                errorBody = e.getResponseBodyAsString();
            }
        }
        catch (Exception e) {
            error = e;
        }
        log.warn("Could not locate PropertySource: {}", errorBody == null ? (error == null ? "no error message" : error.getMessage()) : errorBody);
        return null;
    }

    private io.zhudy.duic.spring.cloud.config.environment.Environment getRemoteEnvironment(ConfigClientProperties properties) {
        ResponseEntity response;
        block4: {
            String token = properties.getToken();
            String name = properties.getName();
            String profile = properties.getProfile();
            String url = properties.getUri() + "/ssc/" + name + "/" + profile;
            response = null;
            try {
                HttpHeaders headers = new HttpHeaders();
                if (StringUtils.hasText((String)token)) {
                    headers.add("x-config-token", token);
                }
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                RestTemplate restTemplate = RestTemplateUtils.getRestTemplate(properties);
                log.info("Fetching config from server at: {}", (Object)url);
                response = restTemplate.exchange(url, HttpMethod.GET, entity, io.zhudy.duic.spring.cloud.config.environment.Environment.class, new Object[0]);
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() == HttpStatus.NOT_FOUND) break block4;
                throw e;
            }
        }
        if (response == null || response.getStatusCode() != HttpStatus.OK) {
            return null;
        }
        io.zhudy.duic.spring.cloud.config.environment.Environment result = (io.zhudy.duic.spring.cloud.config.environment.Environment)response.getBody();
        return result;
    }
}

