/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.spring.cloud.config.client;

import io.zhudy.duic.spring.cloud.config.client.ConfigClientProperties;
import io.zhudy.duic.spring.cloud.config.client.ConfigWatchProperties;
import io.zhudy.duic.spring.cloud.config.client.RestTemplateUtils;
import io.zhudy.duic.spring.cloud.config.environment.State;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class ConfigWatchService
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(ConfigWatchService.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ContextRefresher refresher;
    private Environment environment;
    private ConfigurableListableBeanFactory beanFactory;
    private ConfigClientProperties properties;
    private ConfigWatchProperties configWatchProperties;

    public ConfigWatchService(ContextRefresher refresher, Environment environment, ConfigurableListableBeanFactory beanFactory, ConfigClientProperties clientProperties, ConfigWatchProperties configWatchProperties) {
        this.refresher = refresher;
        this.environment = environment;
        this.beanFactory = beanFactory;
        this.properties = clientProperties;
        this.configWatchProperties = configWatchProperties;
    }

    @PostConstruct
    public void start() {
        if (this.configWatchProperties.isEnabled()) {
            ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
            ses.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConfigWatchService.this.watch();
                    }
                    catch (Exception e) {
                        log.warn("\u76d1\u89c6\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
                    }
                }
            }, this.configWatchProperties.getInitialDelay(), this.configWatchProperties.getFixedDelay(), TimeUnit.MILLISECONDS);
        }
        this.running.compareAndSet(false, true);
    }

    private void watch() {
        if (this.running.get()) {
            String state = this.environment.getProperty("config.client.state");
            String remoteState = this.getRemoteState();
            if (remoteState != null && !remoteState.equals(state)) {
                log.info("Reloading config: name={}, profiles={}, state={}, remoteState={}", new Object[]{this.properties.getName(), this.properties.getProfile(), state, remoteState});
                this.refresher.refresh();
                AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
                bpp.setAutowiredAnnotationType(Value.class);
                bpp.setBeanFactory((BeanFactory)this.beanFactory);
                for (String name : this.beanFactory.getBeanDefinitionNames()) {
                    bpp.processInjection(this.beanFactory.getBean(name));
                }
            }
        }
    }

    private String getRemoteState() {
        String path = "/apps/states/{name}/{profile}";
        String name = this.properties.getName();
        String profile = this.properties.getProfile();
        String uri = this.properties.getUri();
        log.debug("Checking config state from server at: {}", (Object)this.properties.getUri());
        Object[] args = new String[]{name, profile};
        ResponseEntity response = null;
        try {
            RestTemplate restTemplate = RestTemplateUtils.getRestTemplate(this.properties);
            response = restTemplate.exchange(uri + path, HttpMethod.GET, null, State.class, args);
        }
        catch (Exception e) {
            log.warn("Checking config state failed: {}", (Object)e.getMessage());
        }
        if (response == null || response.getStatusCode() != HttpStatus.OK) {
            return null;
        }
        State result = (State)response.getBody();
        return result.getState();
    }

    @Override
    public void close() throws IOException {
        this.running.compareAndSet(true, false);
    }
}

