/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.spring.cloud.config.client;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="duic.spring.cloud.config")
public class ConfigClientProperties {
    public static final String PREFIX = "duic.spring.cloud.config";
    public static final String TOKEN_HEADER = "X-Config-Token";
    private boolean enabled = true;
    private String uri;
    @Value(value="${spring.application.name:application}")
    private String name;
    private String profile = "default";
    private String token = "";
    private int timeout = 30000;

    public ConfigClientProperties override(Environment environment) {
        ConfigClientProperties override = new ConfigClientProperties();
        BeanUtils.copyProperties((Object)this, (Object)override);
        override.setName(environment.resolvePlaceholders("${duic.spring.cloud.config.name:${spring.application.name:application}}"));
        if (environment.containsProperty("duic.spring.cloud.config.profile")) {
            override.setProfile(environment.getProperty("duic.spring.cloud.config.profile"));
        }
        return override;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getToken() {
        return this.token;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigClientProperties)) {
            return false;
        }
        ConfigClientProperties other = (ConfigClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        return this.getTimeout() == other.getTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        result = result * 59 + this.getTimeout();
        return result;
    }

    public String toString() {
        return "ConfigClientProperties(enabled=" + this.isEnabled() + ", uri=" + this.getUri() + ", name=" + this.getName() + ", profile=" + this.getProfile() + ", token=" + this.getToken() + ", timeout=" + this.getTimeout() + ")";
    }
}

