/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.config.spring;

import io.zhudy.duic.config.Config;
import io.zhudy.duic.config.ConfigUtils;
import io.zhudy.duic.config.DuicListener;
import io.zhudy.duic.config.spring.ReloadConfigApplicationListener;
import io.zhudy.duic.config.spring.ReloadConfigEvent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class DuicConfigBeanFactoryPostProcessor
implements EnvironmentAware,
ApplicationContextAware,
BeanFactoryPostProcessor {
    private ConfigurableEnvironment environment;
    private ConfigurableApplicationContext applicationContext;
    private String baseUri;
    private String name;
    private String profile;
    private String configToken;
    private boolean watchEnabled;
    private boolean failFast;
    private List<DuicListener> listeners;
    private String oldState;

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ConfigurableApplicationContext ac = (ConfigurableApplicationContext)applicationContext;
        ReloadConfigApplicationListener listener = (ReloadConfigApplicationListener)applicationContext.getAutowireCapableBeanFactory().createBean(ReloadConfigApplicationListener.class);
        ac.addApplicationListener((ApplicationListener)listener);
        this.applicationContext = ac;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.postProcess();
    }

    private void postProcess() {
        Config config = this.buildConfig();
        ConfigUtils.setDefaultConfig(config);
        this.environment.getPropertySources().addFirst((PropertySource)new PropertySource<String>(ConfigUtils.class.getName()){

            public String getProperty(String name) {
                return ConfigUtils.getString(name, null);
            }
        });
    }

    private Config buildConfig() {
        Config.Builder builder = new Config.Builder().baseUri(this.baseUri).name(this.name).profile(this.profile).configToken(this.configToken).watchEnabled(this.watchEnabled).failFast(this.failFast);
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (DuicListener listener : this.listeners) {
                builder.listener(listener);
            }
        }
        builder.listener(new DuicListener(){

            @Override
            public void handle(String state, Map<String, Object> properties) {
                if (DuicConfigBeanFactoryPostProcessor.this.oldState != null && !Objects.equals(DuicConfigBeanFactoryPostProcessor.this.oldState, state)) {
                    DuicConfigBeanFactoryPostProcessor.this.applicationContext.publishEvent((ApplicationEvent)new ReloadConfigEvent(state));
                }
                DuicConfigBeanFactoryPostProcessor.this.oldState = state;
            }
        });
        return builder.build();
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getConfigToken() {
        return this.configToken;
    }

    public void setConfigToken(String configToken) {
        this.configToken = configToken;
    }

    public boolean isWatchEnabled() {
        return this.watchEnabled;
    }

    public void setWatchEnabled(boolean watchEnabled) {
        this.watchEnabled = watchEnabled;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public List<DuicListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<DuicListener> listeners) {
        this.listeners = listeners;
    }
}

