/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.config;

import io.zhudy.duic.config.DuicClientException;
import io.zhudy.duic.config.internal.JsonParserFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public final class DuicClientUtils {
    private static OkHttpClient httpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(1, 5L, TimeUnit.MINUTES)).connectTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.MINUTES).build();

    private DuicClientUtils() {
        throw new AssertionError((Object)"DuicClientUtils \u4e0d\u80fd\u521b\u5efa\u5b9e\u4f8b");
    }

    public static void setHttpClient(OkHttpClient httpClient) {
        if (httpClient == null) {
            throw new IllegalArgumentException("OkHttpClient \u4e0d\u80fd\u4e3a\u7a7a");
        }
        DuicClientUtils.httpClient = httpClient;
    }

    public static String getState(String url) {
        return DuicClientUtils.getState(url, null);
    }

    public static String getState(String url, String configToken) {
        Map<String, Object> m = DuicClientUtils.get(url, configToken);
        return (String)m.get("state");
    }

    public static String watchState(String url, String state, String configToken) {
        HttpUrl hu = HttpUrl.parse((String)url).newBuilder().addQueryParameter("state", state).build();
        Map<String, Object> m = DuicClientUtils.get(hu, configToken);
        return (String)m.get("state");
    }

    public static Map<String, Object> getProperties(String url) {
        return DuicClientUtils.getProperties(url, null);
    }

    public static Map<String, Object> getProperties(String url, String configToken) {
        return DuicClientUtils.get(url, configToken);
    }

    private static Map<String, Object> get(String url, String configToken) {
        return DuicClientUtils.get(HttpUrl.parse((String)url), configToken);
    }

    private static Map<String, Object> get(HttpUrl url, String configToken) {
        Request.Builder reqBuilder = new Request.Builder();
        reqBuilder.get().url(url);
        if (configToken != null && !configToken.isEmpty()) {
            reqBuilder.header("x-config-token", configToken);
        }
        Request req = reqBuilder.build();
        try (Response resp = null;){
            resp = httpClient.newCall(req).execute();
            if (!resp.isSuccessful()) {
                throw new DuicClientException("\u52a0\u8f7d\u914d\u7f6e [" + url + "] \u5931\u8d25 status=" + resp.code() + ", body=" + resp.body().string());
            }
            Map<String, Object> map = JsonParserFactory.getJsonParser().parse(resp.body().string());
            return map;
        }
    }
}

