/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.config;

import io.zhudy.duic.config.Config;
import io.zhudy.duic.config.ConfigNotFoundException;
import io.zhudy.duic.config.WrongConfigValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);
    private static Config config;

    private ConfigUtils() {
        throw new AssertionError((Object)"ConfigUtils \u4e0d\u80fd\u521b\u5efa\u5b9e\u4f8b");
    }

    public static boolean containsKey(String key) {
        return ConfigUtils.getOrNull(key) != null;
    }

    public static boolean getBoolean(String key) throws ConfigNotFoundException, WrongConfigValueException {
        Object v = ConfigUtils.get(key);
        try {
            if (v instanceof String) {
                return Boolean.parseBoolean((String)v);
            }
            return (Boolean)v;
        }
        catch (Exception e) {
            throw new WrongConfigValueException(key, v, e);
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        Object v = ConfigUtils.getOrNull(key);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof String) {
                return Boolean.parseBoolean((String)v);
            }
            return (Boolean)v;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInt(String key) throws ConfigNotFoundException, WrongConfigValueException {
        Object v = ConfigUtils.get(key);
        try {
            if (v instanceof String) {
                return Double.valueOf((String)v).intValue();
            }
            return ((Number)v).intValue();
        }
        catch (Exception e) {
            throw new WrongConfigValueException(key, v, e);
        }
    }

    public static int getInt(String key, int defaultValue) {
        Object v = ConfigUtils.getOrNull(key);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof String) {
                return Double.valueOf((String)v).intValue();
            }
            return ((Number)v).intValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLong(String key) throws ConfigNotFoundException, WrongConfigValueException {
        Object v = ConfigUtils.get(key);
        try {
            if (v instanceof String) {
                return Double.valueOf((String)v).longValue();
            }
            return ((Number)v).longValue();
        }
        catch (Exception e) {
            throw new WrongConfigValueException(key, v, e);
        }
    }

    public static long getLong(String key, long defaultValue) {
        Object v = ConfigUtils.getOrNull(key);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof String) {
                return Double.valueOf((String)v).longValue();
            }
            return ((Number)v).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static float getFloat(String key) throws ConfigNotFoundException, WrongConfigValueException {
        Object v = ConfigUtils.get(key);
        try {
            if (v instanceof String) {
                return Double.valueOf((String)v).floatValue();
            }
            return ((Number)v).floatValue();
        }
        catch (Exception e) {
            throw new WrongConfigValueException(key, v, e);
        }
    }

    public static float getFloat(String key, float defaultValue) {
        Object v = ConfigUtils.getOrNull(key);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof String) {
                return Double.valueOf((String)v).floatValue();
            }
            return ((Number)v).floatValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double getDouble(String key) throws ConfigNotFoundException, WrongConfigValueException {
        Object v = ConfigUtils.get(key);
        try {
            if (v instanceof String) {
                return Double.parseDouble((String)v);
            }
            return ((Number)v).doubleValue();
        }
        catch (Exception e) {
            throw new WrongConfigValueException(key, v, e);
        }
    }

    public static double getDouble(String key, double defaultValue) {
        Object v = ConfigUtils.getOrNull(key);
        if (v == null) {
            return defaultValue;
        }
        try {
            if (v instanceof String) {
                return Double.parseDouble((String)v);
            }
            return ((Number)v).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getString(String key) {
        Object v = ConfigUtils.get(key);
        try {
            return v.toString();
        }
        catch (Exception e) {
            throw new WrongConfigValueException(key, v, e);
        }
    }

    public static String getString(String key, String defaultValue) {
        Object v = ConfigUtils.get(key, defaultValue);
        try {
            return v.toString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Object get(String key) throws ConfigNotFoundException {
        Object o = ConfigUtils.getOrNull(key);
        if (o == null) {
            throw new ConfigNotFoundException(key);
        }
        return o;
    }

    public static Object get(String key, Object defaultValue) {
        Object v = ConfigUtils.getOrNull(key);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public static Object getOrNull(String key) {
        if (config == null) {
            log.warn("\u672a\u8bbe\u7f6e Config \u5b9e\u4f8b\u8bf7\u5148\u6267\u884c ConfigUtils.setDefaultConfig(Config) \u8bbe\u7f6e\u914d\u7f6e\u5b9e\u4f8b");
            return null;
        }
        return config.get(key);
    }

    public static void setDefaultConfig(Config config) {
        ConfigUtils.config = config;
    }
}

