/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.config;

import io.zhudy.duic.config.ConfigNotFoundException;
import io.zhudy.duic.config.DuicClientUtils;
import io.zhudy.duic.config.DuicListener;
import io.zhudy.duic.config.util.PropertyPlaceholderHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final PropertyPlaceholderHelper PLACEHOLDER_HELPER = new PropertyPlaceholderHelper("${", "}", ":", true);
    private static final Pattern DOT_REGEX = Pattern.compile("\\.");
    private String stateUrl;
    private String propsUrl;
    private String watchStateUrl;
    private String configToken;
    private String state;
    private boolean failFast;
    private Set<DuicListener> listeners;
    private Map<String, Object> properties = Collections.emptyMap();

    private Config(String baseUri, String name, String profile, String configToken, boolean watchEnabled, boolean failFast, Set<DuicListener> listeners) {
        this.configToken = configToken;
        this.failFast = failFast;
        this.listeners = listeners;
        this.stateUrl = HttpUrl.parse((String)baseUri).newBuilder().addPathSegments("apps/states").addPathSegment(name).addPathSegment(profile).build().toString();
        this.propsUrl = HttpUrl.parse((String)baseUri).newBuilder().addPathSegments("apps").addPathSegment(name).addPathSegment(profile).build().toString();
        this.watchStateUrl = HttpUrl.parse((String)baseUri).newBuilder().addPathSegments("apps/watches").addPathSegment(name).addPathSegment(profile).build().toString();
        this.loadProperties();
        if (watchEnabled) {
            this.watch();
        }
    }

    public Object get(String key) {
        if (key == null || key.isEmpty()) {
            throw new ConfigNotFoundException("config key \u4e0d\u80fd\u4e3a null");
        }
        String[] segs = DOT_REGEX.split(key);
        Object p = null;
        for (String k : segs) {
            p = p == null ? this.properties.get(k) : ((Map)p).get(k);
        }
        if (p instanceof String) {
            return PLACEHOLDER_HELPER.replacePlaceholders((String)p, new PropertyPlaceholderHelper.PlaceholderResolver(){

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    Object o = Config.this.get(placeholderName);
                    if (o == null && (o = System.getProperty(placeholderName)) == null) {
                        return System.getenv(placeholderName);
                    }
                    return o != null ? o.toString() : null;
                }
            });
        }
        return p;
    }

    private void loadProperties() {
        try {
            this.state = this.getState();
            long b = System.currentTimeMillis();
            this.properties = DuicClientUtils.getProperties(this.propsUrl, this.configToken);
            log.info("\u52a0\u8f7d DuiC \u914d\u7f6e [{},{}ms]", (Object)this.propsUrl, (Object)(System.currentTimeMillis() - b));
            for (DuicListener listener : this.listeners) {
                listener.handle(this.state, this.properties);
            }
        }
        catch (RuntimeException e) {
            if (this.failFast) {
                throw e;
            }
            log.warn("\u83b7\u53d6\u914d\u7f6e\u9519\u8bef [{}] {}", (Object)this.propsUrl, (Object)e.getMessage());
        }
    }

    private void watch() {
        Thread t = new Thread("duic-watch-state"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            String newState = DuicClientUtils.watchState(Config.this.watchStateUrl, Config.this.state, Config.this.configToken);
                            if (Objects.equals(Config.this.state, newState)) continue;
                            Config.this.loadProperties();
                        }
                    }
                    catch (Exception e) {
                        log.warn("\u83b7\u53d6\u914d\u7f6e\u72b6\u6001\u9519\u8bef [{}]", (Object)Config.this.stateUrl, (Object)e);
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        continue;
                    }
                    break;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private String getState() {
        return DuicClientUtils.getState(this.stateUrl, this.configToken);
    }

    public static class Builder {
        private String baseUri;
        private String name;
        private String profile;
        private String configToken;
        private boolean watchEnabled = false;
        private boolean failFast;
        private Set<DuicListener> listeners = new HashSet<DuicListener>();

        public Builder baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder configToken(String configToken) {
            this.configToken = configToken;
            return this;
        }

        public Builder enableWatch() {
            this.watchEnabled = true;
            return this;
        }

        public Builder watchEnabled(boolean watchEnabled) {
            this.watchEnabled = watchEnabled;
            return this;
        }

        public Builder enableFailFast() {
            this.failFast = true;
            return this;
        }

        public Builder failFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Builder listener(DuicListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Config build() {
            return new Config(this.baseUri, this.name, this.profile, this.configToken, this.watchEnabled, this.failFast, this.listeners);
        }
    }
}

