/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.config.spring;

import io.zhudy.duic.config.spring.ReloadConfigEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;

public class ReloadConfigApplicationListener
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(ReloadConfigApplicationListener.class);
    private static final Set<ConfigurableApplicationContext> applicationContexts = new LinkedHashSet<ConfigurableApplicationContext>(2);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            boolean r = applicationContexts.add((ConfigurableApplicationContext)applicationContext);
            log.info("add application context [{}, {}]", (Object)applicationContext, (Object)r);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            ContextClosedEvent e = (ContextClosedEvent)event;
            boolean r = applicationContexts.remove(e.getApplicationContext());
            log.info("remove application context [{}, {}]", (Object)e.getApplicationContext(), (Object)r);
        } else if (event instanceof ReloadConfigEvent) {
            for (ConfigurableApplicationContext ac : applicationContexts) {
                ConfigurableListableBeanFactory beanFactory = ac.getBeanFactory();
                AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
                bpp.setAutowiredAnnotationType(Value.class);
                bpp.setBeanFactory((BeanFactory)beanFactory);
                for (String name : beanFactory.getBeanDefinitionNames()) {
                    bpp.processInjection(beanFactory.getBean(name));
                }
                log.info("reload @Value annotation config [{}]", (Object)ac);
            }
        }
    }
}

