/*
 * Decompiled with CFR 0.152.
 */
package io.zhudy.duic.config;

import io.zhudy.duic.config.ConfigNotFoundException;
import io.zhudy.duic.config.DuicClientUtils;
import io.zhudy.duic.config.DuicListener;
import io.zhudy.duic.config.ReloadPlot;
import io.zhudy.duic.config.util.PropertyPlaceholderHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final PropertyPlaceholderHelper PLACEHOLDER_HELPER = new PropertyPlaceholderHelper("${", "}", ":", true);
    private String stateUrl;
    private String propsUrl;
    private String configToken;
    private String state;
    private boolean failFast;
    private Set<DuicListener> listeners;
    private Map<String, Object> properties = Collections.emptyMap();

    private Config(String baseUri, String name, String profile, String configToken, ReloadPlot plot, boolean failFast, Set<DuicListener> listeners) {
        this.configToken = configToken;
        this.failFast = failFast;
        this.listeners = listeners;
        this.stateUrl = HttpUrl.parse((String)baseUri).newBuilder().addPathSegments("apps/states").addPathSegment(name).addPathSegment(profile).build().toString();
        this.propsUrl = HttpUrl.parse((String)baseUri).newBuilder().addPathSegments("apps").addPathSegment(name).addPathSegment(profile).build().toString();
        if (plot != null) {
            this.watch(plot);
        }
        this.loadProperties();
    }

    public Object get(String key) throws ConfigNotFoundException {
        Object v = this.getOrNull(key);
        if (v == null) {
            throw new ConfigNotFoundException(key);
        }
        return v;
    }

    public Object getOrNull(String key) {
        if (key == null || key.isEmpty()) {
            throw new ConfigNotFoundException("config key \u4e0d\u80fd\u4e3a null");
        }
        Object p = this.properties.get(key);
        if (p instanceof String) {
            return PLACEHOLDER_HELPER.replacePlaceholders((String)p, new PropertyPlaceholderHelper.PlaceholderResolver(){

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    Object o = Config.this.getOrNull(placeholderName);
                    if (o == null && (o = System.getProperty(placeholderName)) == null) {
                        return System.getenv(placeholderName);
                    }
                    return o.toString();
                }
            });
        }
        return p;
    }

    private void loadProperties() {
        try {
            this.state = this.getState();
            long b = System.currentTimeMillis();
            this.properties = this.getFlattenedMap(DuicClientUtils.getProperties(this.propsUrl, this.configToken));
            log.info("\u52a0\u8f7d DuiC \u914d\u7f6e [{},{}ms]", (Object)this.propsUrl, (Object)(System.currentTimeMillis() - b));
            for (DuicListener listener : this.listeners) {
                listener.handle(this.state, this.properties);
            }
        }
        catch (RuntimeException e) {
            if (this.failFast) {
                throw e;
            }
            log.warn("\u83b7\u53d6\u914d\u7f6e\u9519\u8bef [{}] {}", (Object)this.propsUrl, (Object)e.getMessage());
        }
    }

    private void watch(ReloadPlot plot) {
        ScheduledExecutorService ses = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "duic-reload-config");
                t.setDaemon(true);
                return t;
            }
        });
        ses.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    String newState = Config.this.getState();
                    if (!Objects.equals(Config.this.state, newState)) {
                        Config.this.loadProperties();
                    }
                }
                catch (Exception e) {
                    log.warn("\u83b7\u53d6\u914d\u7f6e\u72b6\u6001\u9519\u8bef [{}] {}", (Object)Config.this.stateUrl, (Object)e.getMessage());
                }
            }
        }, plot.period, plot.period, plot.unit);
    }

    protected final Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result, source, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (path != null && !path.isEmpty()) {
                key = key.startsWith("[") ? path + key : path + '.' + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value : "");
        }
    }

    private String getState() {
        return DuicClientUtils.getState(this.stateUrl, this.configToken);
    }

    public static class Builder {
        private String baseUri;
        private String name;
        private String profile;
        private String configToken;
        private ReloadPlot reloadPlot = new ReloadPlot(30, TimeUnit.SECONDS);
        private boolean failFast;
        private Set<DuicListener> listeners = new HashSet<DuicListener>();

        public Builder baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder configToken(String configToken) {
            this.configToken = configToken;
            return this;
        }

        public Builder reloadPlot(ReloadPlot reloadPlot) {
            this.reloadPlot = reloadPlot;
            return this;
        }

        public Builder failFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Builder listener(DuicListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Config build() {
            return new Config(this.baseUri, this.name, this.profile, this.configToken, this.reloadPlot, this.failFast, this.listeners);
        }
    }
}

