/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.reflect;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import io.ytcode.reflect.util.ReflectException;
import java.lang.reflect.Constructor;
import java.util.Iterator;

public abstract class Filterable<E, F extends Filterable<E, F>>
implements Iterable<E>,
Supplier<ImmutableSet<E>> {
    private final ImmutableSet<E> set;

    protected Filterable(ImmutableSet<E> set) {
        Preconditions.checkNotNull(set);
        this.set = set;
    }

    public final F filter(Predicate<E> p) {
        return this.with(FluentIterable.from(this.set).filter(p).toSet());
    }

    public F with(ImmutableSet<E> set) {
        try {
            Constructor<?> c = this.getClass().getDeclaredConstructor(ImmutableSet.class);
            c.setAccessible(true);
            return (F)((Filterable)c.newInstance(set));
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    @Override
    public final Iterator<E> iterator() {
        return this.set.iterator();
    }

    public final ImmutableSet<E> get() {
        return this.set;
    }

    public final int size() {
        return this.set.size();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("size", this.size()).toString();
    }
}

