/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.reflect.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import io.ytcode.reflect.Reflect;
import io.ytcode.reflect.resource.Resource;
import io.ytcode.reflect.util.ReflectException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Utils {
    public static Predicate<Resource> predicateResourceNameSuffix(final String suffix) {
        return Predicates.compose((Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return s.endsWith(suffix);
            }
        }, (Function)new Function<Resource, String>(){

            public String apply(Resource r) {
                return r.name();
            }
        });
    }

    public static Predicate<Resource> predicateResourceNamePattern(String pattern) {
        return Predicates.compose((Predicate)Predicates.containsPattern((String)pattern), (Function)new Function<Resource, String>(){

            public String apply(Resource r) {
                return r.name();
            }
        });
    }

    public static Predicate<Class<?>> predicateClassSubTypeOf(final Class<?> cls) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input != cls && cls.isAssignableFrom(input);
            }
        };
    }

    public static Predicate<Class<?>> predicateClassAnnotatedWith(Class<? extends Annotation> annotation) {
        return Utils.predicateAnnotatedWith(annotation);
    }

    public static Predicate<Field> predicateFieldAnnotatedWith(Class<? extends Annotation> annotation) {
        return Utils.predicateAnnotatedWith(annotation);
    }

    public static Predicate<Method> predicateMethodAnnotatedWith(Class<? extends Annotation> annotation) {
        return Utils.predicateAnnotatedWith(annotation);
    }

    public static Predicate<Constructor<?>> predicateConstructorAnnotatedWith(Class<? extends Annotation> annotation) {
        return Utils.predicateAnnotatedWith(annotation);
    }

    public static <T extends AnnotatedElement> Predicate<T> predicateAnnotatedWith(final Class<? extends Annotation> annotation) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return input.isAnnotationPresent(annotation);
            }
        };
    }

    public static ImmutableSet<Class<?>> toClasses(Iterable<Resource> resources) {
        return FluentIterable.from(resources).transform(new Function<Resource, Class<?>>(){

            public Class<?> apply(Resource r) {
                String s = r.name();
                s = s.substring(0, s.length() - ".class".length());
                s = s.replace('/', '.');
                try {
                    return r.loader().loadClass(s);
                }
                catch (ClassNotFoundException e) {
                    throw new ReflectException(e);
                }
            }
        }).toSet();
    }

    public static ImmutableSet<Field> toFields(Iterable<Class<?>> classes) {
        return FluentIterable.from(classes).transformAndConcat(new Function<Class<?>, ImmutableSet<Field>>(){

            public ImmutableSet<Field> apply(Class<?> c) {
                return Reflect.fields(c);
            }
        }).toSet();
    }

    public static ImmutableSet<Method> toMethods(Iterable<Class<?>> classes) {
        return FluentIterable.from(classes).transformAndConcat(new Function<Class<?>, ImmutableSet<Method>>(){

            public ImmutableSet<Method> apply(Class<?> c) {
                return Reflect.methods(c);
            }
        }).toSet();
    }

    public static ImmutableSet<Constructor<?>> toConstructors(Iterable<Class<?>> classes) {
        return FluentIterable.from(classes).transformAndConcat(new Function<Class<?>, ImmutableSet<Constructor<?>>>(){

            public ImmutableSet<Constructor<?>> apply(Class<?> c) {
                return Reflect.constructors(c);
            }
        }).toSet();
    }
}

