/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.reflect.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;

public class PathFilter {
    private final ImmutableSet<String> paths;
    private final boolean recursive;
    private final boolean keepLeadingSlash;

    public static PathFilter of(ImmutableSet<String> paths, boolean recursive, boolean keepLeadingSlash) {
        return new PathFilter(paths, recursive, keepLeadingSlash);
    }

    private PathFilter(ImmutableSet<String> paths, boolean recursive, boolean keepLeadingSlash) {
        Preconditions.checkNotNull(paths);
        this.paths = PathFilter.normalizePaths(paths, keepLeadingSlash);
        this.recursive = recursive;
        this.keepLeadingSlash = keepLeadingSlash;
    }

    public boolean isValid(String path) {
        path = this.pathDir(path);
        if (!this.recursive) {
            return this.paths.contains((Object)path);
        }
        for (String s : this.paths) {
            if (!path.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private String pathDir(String path) {
        int idx = path.lastIndexOf(47);
        if (idx < 0) {
            return this.keepLeadingSlash ? "/" : "";
        }
        return path.substring(0, idx + 1);
    }

    private static ImmutableSet<String> normalizePaths(ImmutableSet<String> paths, final boolean keepLeadingSlash) {
        return FluentIterable.from(paths).transform((Function)new Function<String, String>(){

            public String apply(String s) {
                s = CharMatcher.whitespace().trimFrom((CharSequence)s);
                s = CharMatcher.is((char)'/').trimFrom((CharSequence)s);
                int l = s.length();
                if (keepLeadingSlash) {
                    s = "/" + s;
                }
                return l > 0 ? s + "/" : s;
            }
        }).toSet();
    }
}

