/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.reflect.resource;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.ytcode.reflect.Reflect;
import io.ytcode.reflect.resource.Resource;
import io.ytcode.reflect.resource.Resources;
import io.ytcode.reflect.util.PathFilter;
import io.ytcode.reflect.util.ReflectException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner {
    private static final Logger logger = LoggerFactory.getLogger(Scanner.class);
    private static final Splitter CLASS_PATH_ATTRIBUTE_SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private final ImmutableSet<ClassLoader> classLoaders;
    private final PathFilter pathFilter;

    public static Scanner pkgs(String ... pkgs) {
        return Scanner.paths(Reflect.pkgToResPath(pkgs));
    }

    public static Scanner paths(String ... paths) {
        return Scanner.from((ImmutableSet<ClassLoader>)ImmutableSet.of((Object)Thread.currentThread().getContextClassLoader()), (ImmutableSet<String>)ImmutableSet.copyOf((Object[])paths), true);
    }

    public static Scanner from(ImmutableSet<ClassLoader> classLoaders, ImmutableSet<String> paths, boolean recursive) {
        return new Scanner(classLoaders, paths, recursive);
    }

    private Scanner(ImmutableSet<ClassLoader> classLoaders, ImmutableSet<String> paths, boolean recursive) {
        Preconditions.checkNotNull(classLoaders);
        this.classLoaders = classLoaders;
        this.pathFilter = PathFilter.of(paths, recursive, false);
    }

    public Resources scan() {
        return Resources.of(new ScanJob().scan());
    }

    private class ScanJob {
        private final ImmutableSet.Builder<Resource> b = ImmutableSet.builder();
        private final Set<File> scannedFiles = Sets.newHashSet();

        ScanJob() {
        }

        ImmutableSet<Resource> scan() {
            for (ClassLoader classLoader : Scanner.this.classLoaders) {
                if (!(classLoader instanceof URLClassLoader)) {
                    logger.error("Illegal class loader, currently only URLClassLoader is supported! {}", (Object)classLoader);
                    continue;
                }
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                for (URL url : urlClassLoader.getURLs()) {
                    try {
                        this.scan(url, classLoader);
                    }
                    catch (IOException e) {
                        throw new ReflectException(e);
                    }
                }
            }
            return this.b.build();
        }

        private void scan(URL url, ClassLoader loader) throws IOException {
            if (!url.getProtocol().equals("file")) {
                logger.error("Illegal url, currently only file:// url is supported! {}", (Object)url);
                return;
            }
            File file = new File(url.getFile());
            if (!this.scannedFiles.add(file = file.getCanonicalFile())) {
                return;
            }
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory()) {
                this.scanDir(file, loader);
            } else {
                this.scanJar(file, loader);
            }
        }

        private void scanDir(File dir, ClassLoader loader) {
            this.scanDir(dir, loader, "");
        }

        private void scanDir(File dir, ClassLoader loader, String path) {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                String pathName = path + file.getName();
                if (file.isDirectory()) {
                    this.scanDir(file, loader, pathName + "/");
                    continue;
                }
                if (!Scanner.this.pathFilter.isValid(pathName)) continue;
                this.b.add((Object)Resource.of(pathName, loader));
            }
        }

        private void scanJar(File file, ClassLoader loader) throws IOException {
            try (JarFile jarFile = new JarFile(file);){
                this.scanJar(jarFile, loader);
                this.scanJarManifest(file, jarFile.getManifest(), loader);
            }
        }

        private void scanJar(JarFile jarFile, ClassLoader loader) {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || !Scanner.this.pathFilter.isValid(entry.getName())) continue;
                this.b.add((Object)Resource.of(entry.getName(), loader));
            }
        }

        private void scanJarManifest(File file, Manifest manifest, ClassLoader loader) throws IOException {
            if (manifest == null) {
                return;
            }
            String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (Strings.isNullOrEmpty((String)classPath)) {
                return;
            }
            for (String path : CLASS_PATH_ATTRIBUTE_SPLITTER.split((CharSequence)classPath)) {
                URL url = new URL(file.toURI().toURL(), path);
                this.scan(url, loader);
            }
        }
    }
}

