/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.reflect.resource;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class Resource {
    private final String name;
    private final ClassLoader loader;

    public static Resource of(String name, ClassLoader loader) {
        return new Resource(name, loader);
    }

    private Resource(String name, ClassLoader loader) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)loader);
        this.name = name;
        this.loader = loader;
    }

    public String name() {
        return this.name;
    }

    public ClassLoader loader() {
        return this.loader;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Resource) {
            Resource res = (Resource)obj;
            return this.name.equals(res.name) && this.loader == res.loader;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Resource.class).add("name", (Object)this.name).add("loader", (Object)this.loader).toString();
    }
}

