/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Reflect {
    public static ImmutableSet<Class<?>> superTypes(Class<?> c) {
        return Reflect.superTypes(c, Predicates.alwaysTrue());
    }

    public static ImmutableSet<Class<?>> superTypes(Class<?> c, Predicate<Class<?>> p) {
        Class<?>[] c2s;
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(p);
        ImmutableSet.Builder b = ImmutableSet.builder();
        Class<?> c1 = c.getSuperclass();
        if (c1 != null) {
            if (p.apply(c1)) {
                b.add(c1);
            }
            b.addAll(Reflect.superTypes(c1, p));
        }
        if ((c2s = c.getInterfaces()) != null) {
            for (Class<?> c2 : c2s) {
                if (p.apply(c2)) {
                    b.add(c2);
                }
                b.addAll(Reflect.superTypes(c2, p));
            }
        }
        return b.build();
    }

    public static ImmutableSet<Field> fields(Class<?> c) {
        return Reflect.fields(c, (Predicate<Field>)Predicates.alwaysTrue());
    }

    public static ImmutableSet<Field> fields(Class<?> c, Predicate<Field> p) {
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(p);
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (Field field : c.getDeclaredFields()) {
            if (!p.apply((Object)field)) continue;
            b.add((Object)field);
        }
        for (Class cls : Reflect.superTypes(c)) {
            for (Field field : cls.getDeclaredFields()) {
                if (!p.apply((Object)field)) continue;
                b.add((Object)field);
            }
        }
        return b.build();
    }

    public static ImmutableSet<Method> methods(Class<?> c) {
        return Reflect.methods(c, (Predicate<Method>)Predicates.alwaysTrue());
    }

    public static ImmutableSet<Method> methods(Class<?> c, Predicate<Method> p) {
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(p);
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (Method method : c.getDeclaredMethods()) {
            if (!p.apply((Object)method)) continue;
            b.add((Object)method);
        }
        for (Class cls : Reflect.superTypes(c)) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!p.apply((Object)method)) continue;
                b.add((Object)method);
            }
        }
        return b.build();
    }

    public static ImmutableSet<Constructor<?>> constructors(Class<?> c) {
        return Reflect.constructors(c, Predicates.alwaysTrue());
    }

    public static ImmutableSet<Constructor<?>> constructors(Class<?> c, Predicate<Constructor<?>> p) {
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(p);
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (Constructor<?> constructor : c.getDeclaredConstructors()) {
            if (!p.apply(constructor)) continue;
            b.add(constructor);
        }
        for (Class cls : Reflect.superTypes(c)) {
            for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                if (!p.apply(constructor)) continue;
                b.add(constructor);
            }
        }
        return b.build();
    }

    public static String pkgToResPath(String pkg) {
        return pkg.replace('.', '/');
    }

    public static String[] pkgToResPath(String ... pkgs) {
        String[] r = new String[pkgs.length];
        for (int i = 0; i < pkgs.length; ++i) {
            r[i] = Reflect.pkgToResPath(pkgs[i]);
        }
        return r;
    }
}

