/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.pathfinding.astar;

import io.ytcode.pathfinding.astar.Grid;
import io.ytcode.pathfinding.astar.Point;

public class Reachability {
    public static boolean isReachable(int x1, int y1, int x2, int y2, Grid grid) {
        return Reachability.isReachable(x1, y1, x2, y2, 1, grid);
    }

    public static boolean isReachable(int x1, int y1, int x2, int y2, int scale, Grid grid) {
        return Reachability.getClosestWalkablePointToTarget(x1, y1, x2, y2, scale, grid) == Point.toPoint(x2, y2);
    }

    public static long getClosestWalkablePointToTarget(int x1, int y1, int x2, int y2, Grid grid) {
        return Reachability.getClosestWalkablePointToTarget(x1, y1, x2, y2, 1, grid);
    }

    public static long getClosestWalkablePointToTarget(int x1, int y1, int x2, int y2, int scale, Grid grid) {
        double addDy;
        double addDx;
        boolean stepX;
        double cy1;
        int gy1;
        if (scale < 1) {
            throw new IllegalArgumentException("Illegal scale: " + scale);
        }
        double cx1 = Reachability.scaleDown((double)x1 + 0.5, scale);
        int gx1 = (int)cx1;
        if (!grid.isWalkable(gx1, gy1 = (int)(cy1 = Reachability.scaleDown((double)y1 + 0.5, scale)))) {
            return Point.toPoint(x1, y1);
        }
        double cx2 = Reachability.scaleDown((double)x2 + 0.5, scale);
        double cy2 = Reachability.scaleDown((double)y2 + 0.5, scale);
        int gx2 = (int)cx2;
        int gy2 = (int)cy2;
        if (gx1 == gx2 && gy1 == gy2) {
            return Point.toPoint(x2, y2);
        }
        if (y1 == y2) {
            int inc = gx2 > gx1 ? 1 : -1;
            int gx = gx1 + inc;
            while (true) {
                if (!grid.isWalkable(gx, gy1)) {
                    if (gx - inc == gx1) {
                        return Point.toPoint(x1, y1);
                    }
                    return Point.toPoint(Reachability.scaleUp(gx - inc, scale), y1);
                }
                if (gx == gx2) {
                    return Point.toPoint(x2, y2);
                }
                gx += inc;
            }
        }
        if (x1 == x2) {
            int inc = gy2 > gy1 ? 1 : -1;
            int gy = gy1 + inc;
            while (true) {
                if (!grid.isWalkable(gx1, gy)) {
                    if (gy - inc == gy1) {
                        return Point.toPoint(x1, y1);
                    }
                    return Point.toPoint(x1, Reachability.scaleUp(gy - inc, scale));
                }
                if (gy == gy2) {
                    return Point.toPoint(x2, y2);
                }
                gy += inc;
            }
        }
        double dx = cx2 - cx1;
        double dy = cy2 - cy1;
        double k = dy / dx;
        double b = cy1 - k * cx1;
        if (Math.abs(dx) > Math.abs(dy)) {
            stepX = true;
            addDx = dx > 0.0 ? 1.0 : -1.0;
            addDy = addDx * k;
        } else {
            stepX = false;
            addDy = dy > 0.0 ? 1.0 : -1.0;
            addDx = addDy / k;
        }
        double cx = cx1;
        double cy = cy1;
        while (true) {
            int gy0;
            int x0;
            double y0;
            int gx = (int)(cx += addDx);
            int gy = (int)(cy += addDy);
            if (stepX ? (addDx > 0.0 ? gx >= gx2 : gx <= gx2) : (addDy > 0.0 ? gy >= gy2 : gy <= gy2)) {
                gx = gx2;
                gy = gy2;
            }
            if (!grid.isWalkable(gx, gy) || gx != gx1 && gy != gy1 && (Math.rint(y0 = k * (double)(x0 = dx > 0.0 ? gx : gx1) + b) != y0 || k < 0.0) && ((gy0 = (int)y0) != gy ? !grid.isWalkable(gx, gy1) : !grid.isWalkable(gx1, gy))) break;
            if (gx == gx2 && gy == gy2) {
                return Point.toPoint(x2, y2);
            }
            cx1 = cx;
            cy1 = cy;
            gx1 = gx;
            gy1 = gy;
        }
        return Reachability.scaleUpPoint(cx1, cy1, scale);
    }

    private static double scaleDown(double d, int scale) {
        return d / (double)scale;
    }

    private static int scaleUp(int i, int scale) {
        return i * scale + scale / 2;
    }

    private static int scaleUp(double d, int scale) {
        return (int)(d * (double)scale);
    }

    private static long scaleUpPoint(double x, double y, int scale) {
        return Point.toPoint(Reachability.scaleUp(x, scale), Reachability.scaleUp(y, scale));
    }
}

