/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.pathfinding.astar;

import io.ytcode.pathfinding.astar.Grid;
import io.ytcode.pathfinding.astar.Node;
import io.ytcode.pathfinding.astar.TooLongPathException;
import java.util.Arrays;

class Nodes {
    Grid map;
    private long[] nodes = new long[16];
    private int size;
    private static final int HEAP_SHIFT = 2;

    Nodes() {
    }

    void open(int x, int y, int g, int h, int pd) {
        if (this.size >= Grid.MAX_OPEN_NODE_SIZE) {
            throw new TooLongPathException("TooManyOpenNodes! max: " + Grid.MAX_OPEN_NODE_SIZE);
        }
        if (this.size >= this.nodes.length) {
            this.grow(this.size + 1);
        }
        long node = this.node(x, y, g, h, pd);
        this.siftUp(this.size, node);
        ++this.size;
    }

    long close() {
        if (this.size == 0) {
            return 0L;
        }
        long r = this.nodes[0];
        --this.size;
        if (this.size > 0) {
            long n = this.nodes[this.size];
            this.siftDown(0, n);
        }
        this.map.nodeClosed(Node.getX(r), Node.getY(r));
        return r;
    }

    long getOpenNode(int i) {
        assert (i >= 0 && i < this.size);
        return this.nodes[i];
    }

    void openNodeParentChanged(long n, int idx, int pd) {
        this.siftUp(idx, n);
        this.map.nodeParentDirectionUpdate(Node.getX(n), Node.getY(n), pd);
    }

    void clear() {
        this.size = 0;
        this.map.clear();
        this.map = null;
    }

    boolean isClean() {
        return this.size == 0;
    }

    private void siftUp(int i, long n) {
        int pi;
        long p;
        int nf = Node.getF(n);
        while (i > 0 && nf < Node.getF(p = this.nodes[pi = i - 1 >>> 2])) {
            this.setNode(i, p);
            i = pi;
        }
        this.setNode(i, n);
    }

    private void siftDown(int i, long n) {
        int ci;
        int nf = Node.getF(n);
        while (i < this.size && (ci = (i << 2) + 1) < this.size) {
            long c = this.nodes[ci];
            int cj = ci + 1;
            if (cj < this.size) {
                if (Node.getF(this.nodes[cj]) < Node.getF(c)) {
                    ci = cj;
                    c = this.nodes[ci];
                }
                if (++cj < this.size) {
                    if (Node.getF(this.nodes[cj]) < Node.getF(c)) {
                        ci = cj;
                        c = this.nodes[ci];
                    }
                    if (++cj < this.size && Node.getF(this.nodes[cj]) < Node.getF(c)) {
                        ci = cj;
                        c = this.nodes[ci];
                    }
                }
            }
            if (nf <= Node.getF(c)) break;
            this.setNode(i, c);
            i = ci;
        }
        this.setNode(i, n);
    }

    private void setNode(int i, long n) {
        this.nodes[i] = n;
        this.map.openNodeIdxUpdate(Node.getX(n), Node.getY(n), i);
    }

    private long node(int x, int y, int g, int h, int pd) {
        long node = Node.toNode(x, y, g, g + h);
        this.map.nodeParentDirectionUpdate(x, y, pd);
        return node;
    }

    private void grow(int minCapacity) {
        int oldCapacity;
        int newCapacity = oldCapacity + ((oldCapacity = this.nodes.length) < 64 ? oldCapacity + 2 : oldCapacity >> 1);
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            throw new RuntimeException("Overflow");
        }
        this.nodes = Arrays.copyOf(this.nodes, newCapacity);
    }
}

