/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.pathfinding.astar;

import io.ytcode.pathfinding.astar.Grid;

class Reachable {
    private static final double DELTA = 1.0;

    Reachable() {
    }

    static boolean isReachable(int x1, int y1, int x2, int y2, Grid map) {
        assert (map.isWalkable(x1, y1) && map.isWalkable(x2, y2));
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dy == 0) {
            if (x2 > x1) {
                for (int x = x1 + 1; x < x2; ++x) {
                    if (map.isWalkable(x, y1)) continue;
                    return false;
                }
            } else {
                for (int x = x2 + 1; x < x1; ++x) {
                    if (map.isWalkable(x, y1)) continue;
                    return false;
                }
            }
            return true;
        }
        if (dx == 0) {
            if (y2 > y1) {
                for (int y = y1 + 1; y < y2; ++y) {
                    if (map.isWalkable(x1, y)) continue;
                    return false;
                }
            } else {
                for (int y = y2 + 1; y < y1; ++y) {
                    if (map.isWalkable(x1, y)) continue;
                    return false;
                }
            }
            return true;
        }
        double cx1 = (double)x1 + 0.5;
        double cy1 = (double)y1 + 0.5;
        double cx2 = (double)x2 + 0.5;
        double cy2 = (double)y2 + 0.5;
        if (Math.abs(dx) == Math.abs(dy)) {
            double deltaY;
            double deltaX = dx > 0 ? 1.0 : -1.0;
            double d = deltaY = dy > 0 ? 1.0 : -1.0;
            do {
                if (!map.isWalkable((int)(cx1 += deltaX), (int)(cy1 += deltaY))) {
                    return false;
                }
                if (!(dx > 0 && dy < 0 ? !map.isWalkable((int)cx1, (int)(cy1 - deltaY)) : dx < 0 && dy > 0 && !map.isWalkable((int)(cx1 - deltaX), (int)cy1))) continue;
                return false;
            } while (cx1 != cx2 && cy1 != cy2);
            return true;
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            double deltaX = dx > 0 ? 1.0 : -1.0;
            double deltaY = (double)dy / (double)dx * deltaX;
            int lastY = y1;
            do {
                int y;
                int x;
                if (!map.isWalkable(x = (int)(cx1 += deltaX), y = (int)(cy1 += deltaY))) {
                    return false;
                }
                if (y == lastY) continue;
                int lineY = (int)(cy1 - deltaY / 2.0);
                if (lastY == lineY) {
                    if (!map.isWalkable(x, lastY)) {
                        return false;
                    }
                } else {
                    assert (y == lineY);
                    if (!map.isWalkable((int)(cx1 - deltaX), y)) {
                        return false;
                    }
                }
                lastY = y;
            } while (cx1 != cx2);
            return true;
        }
        double deltaY = dy > 0 ? 1.0 : -1.0;
        double deltaX = (double)dx / (double)dy * deltaY;
        int lastX = x1;
        do {
            int y;
            int x;
            if (!map.isWalkable(x = (int)(cx1 += deltaX), y = (int)(cy1 += deltaY))) {
                return false;
            }
            if (x == lastX) continue;
            int lineX = (int)(cx1 - deltaX / 2.0);
            if (lastX == lineX) {
                if (!map.isWalkable(lastX, y)) {
                    return false;
                }
            } else {
                assert (x == lineX);
                if (!map.isWalkable(x, (int)(cy1 - deltaY))) {
                    return false;
                }
            }
            lastX = x;
        } while (cy1 != cy2);
        return true;
    }
}

