/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.pathfinding.astar;

import io.ytcode.pathfinding.astar.Point;
import java.util.Arrays;

public class Path {
    private long[] ps = new long[8];
    private int size;

    void add(int x, int y) {
        long p = Point.toPoint(x, y);
        if (this.size >= this.ps.length) {
            this.grow(this.size + 1);
        }
        this.ps[this.size] = p;
        ++this.size;
    }

    void remove() {
        --this.size;
    }

    public long get(int i) {
        assert (i >= 0 && i < this.size);
        return this.ps[this.size - 1 - i];
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    private void grow(int minCapacity) {
        int oldCapacity;
        int newCapacity = oldCapacity + ((oldCapacity = this.ps.length) < 64 ? oldCapacity + 2 : oldCapacity >> 1);
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            throw new RuntimeException("Overflow");
        }
        this.ps = Arrays.copyOf(this.ps, newCapacity);
    }
}

