/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.pathfinding.astar;

import io.ytcode.pathfinding.astar.Cost;
import io.ytcode.pathfinding.astar.Grid;
import io.ytcode.pathfinding.astar.Node;
import io.ytcode.pathfinding.astar.Nodes;
import io.ytcode.pathfinding.astar.Path;
import io.ytcode.pathfinding.astar.Point;
import io.ytcode.pathfinding.astar.Reachable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AStar {
    private static final Logger logger = LoggerFactory.getLogger(AStar.class);
    private final Nodes nodes = new Nodes();

    public Path search(int sx, int sy, int ex, int ey, Grid map) {
        return this.search(sx, sy, ex, ey, map, false);
    }

    public Path search(int sx, int sy, int ex, int ey, Grid map, boolean smooth) {
        Path p = new Path();
        this.search(sx, sy, ex, ey, map, p, smooth);
        return p;
    }

    public void search(int sx, int sy, int ex, int ey, Grid map, Path path) {
        this.search(sx, sy, ex, ey, map, path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(int sx, int sy, int ex, int ey, Grid map, Path path, boolean smooth) {
        assert (this.isCLean(map));
        if (!map.isWalkable(sx, sy)) {
            return;
        }
        if (!map.isWalkable(ex, ey)) {
            return;
        }
        if (sx == ex && sy == ey) {
            return;
        }
        path.clear();
        int endX = map.getWidth() - 1;
        int endY = map.getHeight() - 1;
        try {
            this.nodes.map = map;
            this.nodes.open(sx, sy, 0, Cost.hCost(sx, sy, ex, ey), 0);
            while (true) {
                long n;
                if ((n = this.nodes.close()) == 0L) {
                    return;
                }
                int x = Node.getX(n);
                int y = Node.getY(n);
                if (x == ex && y == ey) {
                    this.fillPath(ex, ey, sx, sy, path, map, smooth);
                    return;
                }
                int pg = Node.getG(n);
                int x1 = Math.max(x - 1, 0);
                int x2 = Math.min(x + 1, endX);
                int y1 = Math.max(y - 1, 0);
                int y2 = Math.min(y + 1, endY);
                this.open(x, y1, pg + 5, 0, ex, ey, map);
                this.open(x, y2, pg + 5, 1, ex, ey, map);
                this.open(x2, y, pg + 5, 2, ex, ey, map);
                this.open(x1, y, pg + 5, 3, ex, ey, map);
                this.open(x2, y1, pg + 7, 4, ex, ey, map);
                this.open(x2, y2, pg + 7, 5, ex, ey, map);
                this.open(x1, y1, pg + 7, 6, ex, ey, map);
                this.open(x1, y2, pg + 7, 7, ex, ey, map);
                continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("AStar.search: from {}-{} to {}-{}", new Object[]{sx, sy, ex, ey, e});
            path.clear();
            this.clear();
            if ($assertionsDisabled) return;
            if (this.isCLean(map)) return;
            throw new AssertionError();
        }
        finally {
            this.clear();
            assert (this.isCLean(map));
        }
    }

    private void open(int x, int y, int g, int pd, int ex, int ey, Grid map) {
        int info = map.info(x, y);
        if (Grid.isUnwalkable(info)) {
            return;
        }
        switch (pd) {
            case 7: {
                if (map.isWalkable(x + 1, y)) break;
                return;
            }
            case 4: {
                if (map.isWalkable(x, y + 1)) break;
                return;
            }
        }
        if (Grid.isNullNode(info)) {
            this.nodes.open(x, y, g, Cost.hCost(x, y, ex, ey), pd);
            return;
        }
        if (Grid.isClosedNode(info)) {
            return;
        }
        int idx = Grid.openNodeIdx(info);
        long n = this.nodes.getOpenNode(idx);
        int ng = Node.getG(n);
        if (g >= ng) {
            return;
        }
        n = Node.setGF(n, g, Node.getF(n) - ng + g);
        this.nodes.openNodeParentChanged(n, idx, pd);
    }

    private void fillPath(int ex, int ey, int sx, int sy, Path path, Grid map, boolean smooth) {
        this.fillPath(ex, ey, path, map, smooth);
        int pd = map.nodeParentDirection(ex, ey);
        while (true) {
            switch (pd) {
                case 0: {
                    ++ey;
                    break;
                }
                case 1: {
                    --ey;
                    break;
                }
                case 2: {
                    --ex;
                    break;
                }
                case 3: {
                    ++ex;
                    break;
                }
                case 4: {
                    --ex;
                    ++ey;
                    break;
                }
                case 5: {
                    --ex;
                    --ey;
                    break;
                }
                case 6: {
                    ++ex;
                    ++ey;
                    break;
                }
                case 7: {
                    ++ex;
                    --ey;
                    break;
                }
                default: {
                    throw new RuntimeException("illegal direction: " + pd);
                }
            }
            if (ex == sx && ey == sy) {
                this.fillPath(ex, ey, path, map, smooth);
                return;
            }
            int ppd = map.nodeParentDirection(ex, ey);
            if (ppd == pd) continue;
            this.fillPath(ex, ey, path, map, smooth);
            pd = ppd;
        }
    }

    private void fillPath(int x, int y, Path path, Grid map, boolean smooth) {
        if (!smooth) {
            path.add(x, y);
            return;
        }
        while (path.size() >= 2) {
            int y2;
            long p = path.get(1);
            int x2 = Point.getX(p);
            if (!Reachable.isReachable(x, y, x2, y2 = Point.getY(p), map)) {
                path.add(x, y);
                return;
            }
            path.remove();
        }
        path.add(x, y);
    }

    private void clear() {
        this.nodes.clear();
    }

    private boolean isCLean(Grid map) {
        return this.nodes.isClean() && map.isClean();
    }
}

