/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.geometry;

class Utils {
    Utils() {
    }

    static void check(boolean b) {
        if (!b) {
            throw new RuntimeException();
        }
    }

    static void check(boolean b, String msg) {
        if (!b) {
            throw new RuntimeException(msg);
        }
    }

    static void check(boolean b, String format, Object ... args) {
        if (!b) {
            throw new RuntimeException(String.format(format, args));
        }
    }

    static void checkAngle(int angle) {
        Utils.check(angle >= 0 && angle < 360, "Illegal angle %s, legal range [0,360)", angle);
    }

    static int round(double d) {
        return Math.toIntExact(Math.round(d));
    }

    static long longMask(int nbit) {
        Utils.check(nbit >= 1 && nbit <= 64);
        return nbit == 64 ? -1L : (1L << nbit) - 1L;
    }

    static long toLong(int i) {
        return (long)i & Utils.longMask(32);
    }

    static long multiplyExactToLong(int a, int b) {
        return Math.multiplyExact((long)a, (long)b);
    }

    static boolean isOdd(int i) {
        return !Utils.isEven(i);
    }

    static boolean isEven(int i) {
        return (i & 1) == 0;
    }
}

