/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.geometry;

import io.ytcode.geometry.Angle;
import io.ytcode.geometry.Line;
import io.ytcode.geometry.Point;
import io.ytcode.geometry.Utils;
import java.util.Arrays;

public class Polygon {
    private final int[] xx;
    private final int[] yy;
    private final int x1;
    private final int x2;
    private final int y1;
    private final int y2;
    private RotatedEdge[] rotatedEdges;

    public static Polygon from(int[] xx, int[] yy) {
        return Polygon.from(xx, yy, false);
    }

    public static Polygon from(int[] xx, int[] yy, boolean optimizeForSpeed) {
        Utils.check(Polygon.isValid(xx, yy), "Polygon.from illegal points! %s, %s", Arrays.toString(xx), Arrays.toString(yy));
        return new Polygon(xx, yy, optimizeForSpeed);
    }

    private Polygon(int[] xx, int[] yy, boolean optimizeForSpeed) {
        this.xx = xx;
        this.yy = yy;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (int x : xx) {
            if (x < minX) {
                minX = x;
            }
            if (x <= maxX) continue;
            maxX = x;
        }
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int y : yy) {
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        this.x1 = minX;
        this.x2 = maxX;
        this.y1 = minY;
        this.y2 = maxY;
        if (optimizeForSpeed) {
            this.initRotatedEdgesIfNull();
        }
    }

    public boolean contains(int px, int py, int angle, int x, int y) {
        angle = Angle.getAngularDistanceByRotatingCounterclockwise(angle, 0);
        long p = Point.rotateCounterclockwise(px, py, x, y, angle);
        x = Point.getX(p);
        y = Point.getY(p);
        if (!Point.isInsideRectangle(this.x1, this.x2, this.y1, this.y2, x = Math.subtractExact(x, px), y = Math.subtractExact(y, py))) {
            return false;
        }
        return Point.isInsidePolygon(this.xx, this.yy, x, y);
    }

    public boolean intersectsCircle(int px, int py, int angle, int cx, int cy, int r) {
        Utils.checkAngle(angle);
        angle = Angle.getAngularDistanceByRotatingCounterclockwise(angle, 0);
        long p = Point.rotateCounterclockwise(px, py, cx, cy, angle);
        cx = Point.getX(p);
        cy = Point.getY(p);
        cx = Math.subtractExact(cx, px);
        cy = Math.subtractExact(cy, py);
        if (!Point.isInsideRectangle(Math.subtractExact(this.x1, r), Math.addExact(this.x2, r), Math.subtractExact(this.y1, r), Math.addExact(this.y2, r), cx, cy)) {
            return false;
        }
        if (Point.isInsidePolygon(this.xx, this.yy, cx, cy)) {
            return true;
        }
        this.initRotatedEdgesIfNull();
        for (RotatedEdge edge : this.rotatedEdges) {
            if (!edge.intersectsCircle(cx, cy, r)) continue;
            return true;
        }
        return false;
    }

    private void initRotatedEdgesIfNull() {
        if (this.rotatedEdges != null) {
            return;
        }
        RotatedEdge[] r = new RotatedEdge[this.xx.length];
        int lx = this.xx[this.xx.length - 1];
        int ly = this.yy[this.yy.length - 1];
        for (int i = 0; i < r.length; ++i) {
            int nx = this.xx[i];
            int ny = this.yy[i];
            r[i] = new RotatedEdge(lx, ly, nx, ny);
            lx = nx;
            ly = ny;
        }
        this.rotatedEdges = r;
    }

    public static boolean isValid(int[] xx, int[] yy) {
        return Polygon.isValid(xx, yy, true);
    }

    public static boolean isValid(int[] xx, int[] yy, boolean strict) {
        if (xx.length != yy.length) {
            return false;
        }
        if (xx.length < 3) {
            return false;
        }
        int c = xx.length;
        for (int i = 0; i < xx.length; ++i) {
            int[] l1 = Polygon.getLine(xx, yy, i);
            if (l1[0] == l1[2] && l1[1] == l1[3]) {
                if (strict) {
                    return false;
                }
                --c;
            }
            int[] l2 = Polygon.getLine(xx, yy, i + 1);
            if (Angle.getRadians(l1[0], l1[1], l1[2], l1[3]) == Angle.getRadians(l2[0], l2[1], l2[2], l2[3])) {
                return false;
            }
            for (int[] l3 : Polygon.getNotAdjacentLines(xx, yy, i)) {
                if (!Line.intersectsLine(l1[0], l1[1], l1[2], l1[3], l3[0], l3[1], l3[2], l3[3])) continue;
                return false;
            }
        }
        return c >= 3;
    }

    private static int[] getLine(int[] xx, int[] yy, int i) {
        if ((i %= xx.length) == xx.length - 1) {
            return new int[]{xx[i], yy[i], xx[0], yy[0]};
        }
        return new int[]{xx[i], yy[i], xx[i + 1], yy[i + 1]};
    }

    private static int[][] getNotAdjacentLines(int[] xx, int[] yy, int i) {
        int[][] r = new int[xx.length - 3][];
        for (int j = 0; j < r.length; ++j) {
            r[j] = Polygon.getLine(xx, yy, i + 2 + j);
        }
        return r;
    }

    private static class RotatedEdge {
        final int rotatedAngle;
        final int x1;
        final int x2;
        final int y1;

        RotatedEdge(int x1, int y1, int x2, int y2) {
            int angle = Angle.getDegrees(x1, y1, x2, y2);
            this.rotatedAngle = Angle.getAngularDistanceByRotatingCounterclockwise(angle, 0);
            long p = Point.rotateCounterclockwise(x1, y1, x2, y2, this.rotatedAngle);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = Point.getX(p);
        }

        boolean intersectsCircle(int x, int y, int r) {
            long p = Point.rotateCounterclockwise(this.x1, this.y1, x, y, this.rotatedAngle);
            x = Point.getX(p);
            y = Point.getY(p);
            return Line.intersectsCircle(this.x1, this.x2, this.y1, x, y, r);
        }
    }
}

