/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.geometry;

import io.ytcode.geometry.Angle;
import io.ytcode.geometry.Geometry;
import io.ytcode.geometry.Utils;

public class Point {
    public static long move(int x, int y, int angle, double distance) {
        x = Math.addExact(x, Utils.round(distance * Geometry.cos(angle)));
        y = Math.addExact(y, Utils.round(distance * Geometry.sin(angle)));
        return Point.toPoint(x, y);
    }

    public static long rotateCounterclockwise(int cx, int cy, int x, int y, int angle) {
        Utils.checkAngle(angle);
        int deltaX = Math.subtractExact(x, cx);
        int deltaY = Math.subtractExact(y, cy);
        double sin = Geometry.sin(angle);
        double cos = Geometry.cos(angle);
        x = Math.addExact(cx, Utils.round((double)deltaX * cos - (double)deltaY * sin));
        y = Math.addExact(cy, Utils.round((double)deltaX * sin + (double)deltaY * cos));
        return Point.toPoint(x, y);
    }

    public static long rotateClockwise(int cx, int cy, int x, int y, int angle) {
        Utils.checkAngle(angle);
        int deltaX = Math.subtractExact(x, cx);
        int deltaY = Math.subtractExact(y, cy);
        double sin = Geometry.sin(angle);
        double cos = Geometry.cos(angle);
        x = Math.addExact(cx, Utils.round((double)deltaX * cos + (double)deltaY * sin));
        y = Math.addExact(cy, Utils.round((double)deltaY * cos - (double)deltaX * sin));
        return Point.toPoint(x, y);
    }

    public static int positionRelativeToLine(int fromX, int fromY, int toX, int toY, int x, int y) {
        long r = Math.subtractExact(Utils.multiplyExactToLong(Math.subtractExact(x, fromX), Math.subtractExact(toY, fromY)), Utils.multiplyExactToLong(Math.subtractExact(y, fromY), Math.subtractExact(toX, fromX)));
        if (r < 0L) {
            return -1;
        }
        if (r > 0L) {
            return 1;
        }
        return 0;
    }

    public static boolean isOnLine(int fromX, int fromY, int toX, int toY, int x, int y) {
        return Point.positionRelativeToLine(fromX, fromY, toX, toY, x, y) == 0;
    }

    public static boolean isOnTheLeftSideOfTheLine(int fromX, int fromY, int toX, int toY, int x, int y) {
        return Point.positionRelativeToLine(fromX, fromY, toX, toY, x, y) < 0;
    }

    public static boolean isOnTheRightSideOfTheLine(int fromX, int fromY, int toX, int toY, int x, int y) {
        return Point.positionRelativeToLine(fromX, fromY, toX, toY, x, y) > 0;
    }

    public static boolean isOnLineSegment(int fromX, int fromY, int toX, int toY, int x, int y) {
        int b;
        int a;
        if (fromX < toX) {
            a = fromX;
            b = toX;
        } else {
            a = toX;
            b = fromX;
        }
        if (x < a || x > b) {
            return false;
        }
        if (fromY < toY) {
            a = fromY;
            b = toY;
        } else {
            a = toY;
            b = fromY;
        }
        if (y < a || y > b) {
            return false;
        }
        return Point.isOnLine(fromX, fromY, toX, toY, x, y);
    }

    public static boolean isInsideRectangle(int x1, int x2, int y1, int y2, int x, int y) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static boolean isInsideRectangle(int rx, int ry, int rcxOffset, int rcyOffset, int width, int height, int angle, int x, int y) {
        Utils.checkAngle(angle);
        angle = Angle.getAngularDistanceByRotatingCounterclockwise(angle, 0);
        long p = Point.rotateCounterclockwise(rx, ry, x, y, angle);
        x = Point.getX(p);
        y = Point.getY(p);
        int rcx = Math.addExact(rx, rcxOffset);
        int rcy = Math.addExact(ry, rcyOffset);
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        int x1 = Math.subtractExact(rcx, halfWidth);
        int x2 = Math.addExact(rcx, halfWidth);
        int y1 = Math.subtractExact(rcy, halfHeight);
        int y2 = Math.addExact(rcy, halfHeight);
        if (Utils.isEven(width)) {
            x2 = Math.subtractExact(x2, 1);
        }
        if (Utils.isEven(height)) {
            y2 = Math.subtractExact(y2, 1);
        }
        return Point.isInsideRectangle(x1, x2, y1, y2, x, y);
    }

    public static boolean isInsideRectangle(int rx, int ry, int width, int height, int angle, int x, int y) {
        return Point.isInsideRectangle(rx, ry, 0, 0, width, height, angle, x, y);
    }

    public static boolean isInsideCircle(int cx, int cy, int r, int x, int y) {
        int dx = Math.subtractExact(x, cx);
        int dy = Math.subtractExact(y, cy);
        return Point.isInsideCircle(r, dx, dy);
    }

    public static boolean isInsideCircle(int r, int x, int y) {
        if (Math.abs(x) > r) {
            return false;
        }
        if (Math.abs(y) > r) {
            return false;
        }
        return Math.addExact(Utils.multiplyExactToLong(x, x), Utils.multiplyExactToLong(y, y)) <= Utils.multiplyExactToLong(r, r);
    }

    public static boolean isInsideSector(int cx, int cy, int r, int middleRayAngle, int halfCentralAngle, int x, int y) {
        Utils.checkAngle(middleRayAngle);
        if (!Point.isInsideCircle(cx, cy, r, x, y)) {
            return false;
        }
        return Point.isInsideAngle(cx, cy, middleRayAngle, halfCentralAngle, x, y);
    }

    public static boolean isInsideAngle(int cx, int cy, int middleRayAngle, int halfCentralAngle, int x, int y) {
        if (halfCentralAngle >= 180) {
            return true;
        }
        int a = Angle.getDegrees(cx, cy, x, y);
        return (a = Angle.getShortestAngularDistance(a, middleRayAngle)) <= halfCentralAngle;
    }

    public static boolean isInsideEllipse(int cx, int cy, int a, int b, int angle, int x, int y) {
        int dx;
        if (angle != 90 && angle != 270) {
            angle = Angle.getAngularDistanceByRotatingCounterclockwise(angle, 90);
            long p = Point.rotateCounterclockwise(cx, cy, x, y, angle);
            x = Point.getX(p);
            y = Point.getY(p);
        }
        if (Math.abs(dx = Math.subtractExact(x, cx)) > a) {
            return false;
        }
        int dy = Math.subtractExact(y, cy);
        if (Math.abs(dy) > b) {
            return false;
        }
        long dxx = Utils.multiplyExactToLong(dx, dx);
        long dyy = Utils.multiplyExactToLong(dy, dy);
        long aa = Utils.multiplyExactToLong(a, a);
        long bb = Utils.multiplyExactToLong(b, b);
        return Math.addExact(Math.multiplyExact(dxx, bb), Math.multiplyExact(dyy, aa)) <= Math.multiplyExact(aa, bb);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isInsidePolygon(int[] xx, int[] yy, double x, double y) {
        hits = 0;
        lastx = xx[xx.length - 1];
        lasty = yy[yy.length - 1];
        for (i = 0; i < xx.length; ++i) {
            block7: {
                block10: {
                    block11: {
                        block9: {
                            block8: {
                                curx = xx[i];
                                cury = yy[i];
                                if (cury == lasty) break block7;
                                if (curx >= lastx) break block8;
                                if (x >= (double)lastx) break block7;
                                leftx = curx;
                                break block9;
                            }
                            if (x >= (double)curx) break block7;
                            leftx = lastx;
                        }
                        if (cury >= lasty) break block10;
                        if (y < (double)cury || y >= (double)lasty) break block7;
                        if (!(x < (double)leftx)) break block11;
                        ++hits;
                        break block7;
                    }
                    test1 = x - (double)curx;
                    test2 = y - (double)cury;
                    ** GOTO lbl32
                }
                if (y < (double)lasty || y >= (double)cury) break block7;
                if (x < (double)leftx) {
                    ++hits;
                } else {
                    test1 = x - (double)lastx;
                    test2 = y - (double)lasty;
lbl32:
                    // 2 sources

                    if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    public static long toPoint(int x, int y) {
        return Utils.toLong(x) << 32 | Utils.toLong(y);
    }

    public static int getY(long l) {
        return (int)l;
    }

    public static int getX(long l) {
        return (int)(l >>> 32);
    }
}

