/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.geometry;

import io.ytcode.geometry.Angle;
import io.ytcode.geometry.Geometry;
import io.ytcode.geometry.Point;
import io.ytcode.geometry.Utils;
import java.util.concurrent.ThreadLocalRandom;

public class Circle {
    public static boolean intersectsRectangle2(int x1, int x2, int y1, int y2, int cx, int cy, int r) {
        if (!Point.isInsideRectangle(Math.subtractExact(x1, r), Math.addExact(x2, r), Math.subtractExact(y1, r), Math.addExact(y2, r), cx, cy)) {
            return false;
        }
        if (cx >= x1 && cx <= x2) {
            return true;
        }
        if (cy >= y1 && cy <= y2) {
            return true;
        }
        if (Point.isInsideCircle(x1, y1, r, cx, cy)) {
            return true;
        }
        if (Point.isInsideCircle(x2, y1, r, cx, cy)) {
            return true;
        }
        if (Point.isInsideCircle(x1, y2, r, cx, cy)) {
            return true;
        }
        return Point.isInsideCircle(x2, y2, r, cx, cy);
    }

    public static boolean intersectsRectangle(int rx, int ry, int rcxOffset, int rcyOffset, int width, int height, int angle, int cx, int cy, int r) {
        Utils.checkAngle(angle);
        angle = Angle.getAngularDistanceByRotatingCounterclockwise(angle, 0);
        long p = Point.rotateCounterclockwise(rx, ry, cx, cy, angle);
        cx = Point.getX(p);
        cy = Point.getY(p);
        int rcx = Math.addExact(rx, rcxOffset);
        int rcy = Math.addExact(ry, rcyOffset);
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        int x1 = Math.subtractExact(rcx, halfWidth);
        int x2 = Math.addExact(rcx, halfWidth);
        int y1 = Math.subtractExact(rcy, halfHeight);
        int y2 = Math.addExact(rcy, halfHeight);
        if (Utils.isEven(width)) {
            x2 = Math.subtractExact(x2, 1);
        }
        if (Utils.isEven(height)) {
            y2 = Math.subtractExact(y2, 1);
        }
        return Circle.intersectsRectangle2(x1, x2, y1, y2, cx, cy, r);
    }

    public static boolean intersectsRectangle(int rx, int ry, int width, int height, int angle, int cx, int cy, int r) {
        return Circle.intersectsRectangle(rx, ry, 0, 0, width, height, angle, cx, cy, r);
    }

    public static boolean intersectsCircle(int cx1, int cy1, int r1, int cx2, int cy2, int r2) {
        int dr = Math.addExact(r1, r2);
        int dx = Math.subtractExact(cx2, cx1);
        int dy = Math.subtractExact(cy2, cy1);
        return Point.isInsideCircle(dr, dx, dy);
    }

    public static boolean intersectsSector(int cx1, int cy1, int r1, int middleRayAngle, int halfCentralAngle, int cx2, int cy2, int r2) {
        Utils.checkAngle(middleRayAngle);
        if (!Circle.intersectsCircle(cx1, cy1, r1, cx2, cy2, r2)) {
            return false;
        }
        if (Point.isInsideAngle(cx1, cy1, middleRayAngle, halfCentralAngle, cx2, cy2)) {
            return true;
        }
        if (Point.isInsideCircle(r2, Math.subtractExact(cx2, cx1), Math.subtractExact(cy2, cy1))) {
            return true;
        }
        int edgeX = cx1 + r1;
        int angle = middleRayAngle - halfCentralAngle;
        angle = Angle.normalizeDegrees(angle);
        angle = Angle.getAngularDistanceByRotatingCounterclockwise(angle, 0);
        long p = Point.rotateCounterclockwise(cx1, cy1, cx2, cy2, angle);
        int newCx2 = Point.getX(p);
        int newCy2 = Point.getY(p);
        if (newCx2 >= cx1 && (newCx2 <= edgeX ? newCy2 <= cy1 && newCy2 >= Math.subtractExact(cy1, r2) : Point.isInsideCircle(r2, Math.subtractExact(newCx2, edgeX), Math.subtractExact(newCy2, cy1)))) {
            return true;
        }
        angle = middleRayAngle + halfCentralAngle;
        angle = Angle.normalizeDegrees(angle);
        angle = Angle.getAngularDistanceByRotatingCounterclockwise(angle, 0);
        p = Point.rotateCounterclockwise(cx1, cy1, cx2, cy2, angle);
        newCx2 = Point.getX(p);
        newCy2 = Point.getY(p);
        return newCx2 >= cx1 && (newCx2 <= edgeX ? newCy2 >= cy1 && newCy2 <= Math.addExact(cy1, r2) : Point.isInsideCircle(r2, Math.subtractExact(newCx2, edgeX), Math.subtractExact(newCy2, cy1)));
    }

    public static boolean intersectsEllipse(int cx1, int cy1, int a, int b, int angle, int cx2, int cy2, int r) {
        return Point.isInsideEllipse(cx1, cy1, Math.addExact(a, r), Math.addExact(b, r), angle, cx2, cy2);
    }

    public static long randomPointOnTheEdge(int cx, int cy, int r) {
        int angle = ThreadLocalRandom.current().nextInt(360);
        int x = Math.addExact(cx, Utils.round(Geometry.cos(angle) * (double)r));
        int y = Math.addExact(cy, Utils.round(Geometry.sin(angle) * (double)r));
        return Point.toPoint(x, y);
    }

    public static long randomPoint(int cx, int cy, int r) {
        return Circle.randomPointOnTheEdge(cx, cy, ThreadLocalRandom.current().nextInt(r));
    }
}

