/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.geometry;

import io.ytcode.geometry.Utils;

public class Geometry {
    private static final double[] cacheSin;
    private static final double[] cacheCos;
    private static final double[] cacheTan;

    public static double sin(int degrees) {
        return cacheSin[degrees];
    }

    public static double cos(int degrees) {
        return cacheCos[degrees];
    }

    public static double tan(int degrees) {
        return cacheTan[degrees];
    }

    public static double getDistance(int x1, int y1, int x2, int y2) {
        int a = Math.subtractExact(x2, x1);
        a = Math.multiplyExact(a, a);
        int b = Math.subtractExact(y2, y1);
        b = Math.multiplyExact(b, b);
        return Math.sqrt(Math.addExact(a, b));
    }

    public static int getDistanceToInt(int x1, int y1, int x2, int y2) {
        return Utils.round(Geometry.getDistance(x1, y1, x2, y2));
    }

    static {
        int degrees = 360;
        cacheSin = new double[degrees];
        cacheCos = new double[degrees];
        cacheTan = new double[degrees];
        for (int i = 0; i < degrees; ++i) {
            Geometry.cacheSin[i] = Math.sin(Math.toRadians(i));
            Geometry.cacheCos[i] = Math.cos(Math.toRadians(i));
            Geometry.cacheTan[i] = Math.tan(Math.toRadians(i));
        }
    }
}

