/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.geometry;

import io.ytcode.geometry.Utils;

public class Angle {
    public static double getRadians(int fromX, int fromY, int toX, int toY) {
        double angle = Math.atan2(Math.subtractExact(toY, fromY), Math.subtractExact(toX, fromX));
        if (angle < 0.0) {
            angle = Math.PI * 2 + angle;
        }
        return angle;
    }

    public static int getDegrees(int fromX, int fromY, int toX, int toY) {
        int d = (int)Math.round(Math.toDegrees(Angle.getRadians(fromX, fromY, toX, toY)));
        return d == 360 ? 0 : d;
    }

    public static int getShortestAngularDistance(int angle1, int angle2) {
        Utils.checkAngle(angle1);
        Utils.checkAngle(angle2);
        int a = Math.abs(angle2 - angle1);
        return a <= 180 ? a : 360 - a;
    }

    public static int getAngularDistanceByRotatingCounterclockwise(int fromAngle, int toAngle) {
        Utils.checkAngle(fromAngle);
        Utils.checkAngle(toAngle);
        return fromAngle <= toAngle ? toAngle - fromAngle : 360 - (fromAngle - toAngle);
    }

    public static int normalizeDegrees(int angle) {
        if (angle >= 0 && angle < 360) {
            return angle;
        }
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return angle;
    }
}

