/*
 * Decompiled with CFR 0.152.
 */
package io.yggdrash.contract.core;

import io.yggdrash.contract.core.ContractEvent;
import io.yggdrash.contract.core.ContractEventSet;
import io.yggdrash.contract.core.ExecuteStatus;
import io.yggdrash.contract.core.Receipt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ReceiptImpl
implements Receipt {
    private String issuer;
    private String branchId;
    private String blockId;
    private Long blockSize;
    private Long blockHeight;
    private String txId;
    private Long txSize;
    private String contractVersion;
    private String method;
    private final List<String> log = new ArrayList<String>();
    private ExecuteStatus status = ExecuteStatus.FALSE;
    private ContractEventSet event = new ContractEventSet();

    public ReceiptImpl() {
    }

    public static Receipt createTxReceipt(String issuer, String branchId, String txId, long txSize, long blockHeight, String contractVersion) {
        ReceiptImpl receipt = new ReceiptImpl(txId, txSize, issuer);
        receipt.setBranchId(branchId);
        receipt.setContractVersion(contractVersion);
        receipt.setBlockHeight(blockHeight);
        return receipt;
    }

    public static Receipt createBlockReceipt(String branchId, String blockId, long blockSize, long blockHeight, String contractVersion) {
        ReceiptImpl receipt = new ReceiptImpl(blockId, blockSize, blockHeight, branchId);
        receipt.setContractVersion(contractVersion);
        return receipt;
    }

    public ReceiptImpl(String blockId, Long blockSize, Long blockHeight, String branchId) {
        this.blockId = blockId;
        this.blockSize = blockSize;
        this.blockHeight = blockHeight;
        this.branchId = branchId;
    }

    public ReceiptImpl(String txId, Long txSize, String issuer) {
        this.txId = txId;
        this.txSize = txSize;
        this.issuer = issuer;
    }

    @Override
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Override
    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    @Override
    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    @Override
    public void setBlockHeight(Long blockHeight) {
        this.blockHeight = blockHeight;
    }

    @Override
    public void setTxId(String txId) {
        this.txId = txId;
    }

    @Override
    public void setContractVersion(String contractVersion) {
        this.contractVersion = contractVersion;
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public void addLog(String msg) {
        this.log.add(msg);
    }

    @Override
    public void setStatus(ExecuteStatus status) {
        this.status = status;
    }

    @Override
    public void addEvent(ContractEvent event) {
        this.event.addEvent(event);
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getBranchId() {
        return this.branchId;
    }

    @Override
    public String getBlockId() {
        return this.blockId;
    }

    @Override
    public Long getBlockSize() {
        return this.blockSize;
    }

    @Override
    public Long getBlockHeight() {
        return this.blockHeight;
    }

    @Override
    public String getTxId() {
        return this.txId;
    }

    @Override
    public Long getTxSize() {
        return this.txSize;
    }

    @Override
    public String getContractVersion() {
        return this.contractVersion;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public List<String> getLog() {
        return this.log;
    }

    @Override
    public boolean isSuccess() {
        return this.status == ExecuteStatus.SUCCESS;
    }

    @Override
    public ExecuteStatus getStatus() {
        return this.status;
    }

    @Override
    public Set<ContractEvent> getEvents() {
        return this.event.getEvents();
    }
}

