/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.uber.tchannel.codecs.CodecUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.yarpc.util.BufferUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HeaderUtil {
    public static Map<String, String> decodeHeaders(ByteBuf headers) {
        if (headers == null || headers instanceof EmptyByteBuf) {
            return new HashMap<String, String>();
        }
        return CodecUtils.decodeHeaders((ByteBuf)headers);
    }

    public static Map<String, String> decodeHeadersJsonStyle(ByteBuf headers) throws IOException {
        if (headers == null || headers instanceof EmptyByteBuf) {
            return new HashMap<String, String>();
        }
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(BufferUtil.toBytes(headers), (JavaType)mapper.getTypeFactory().constructMapType(HashMap.class, String.class, String.class));
    }

    public static ByteBuf encodeHeaders(Map<String, String> applicationHeaders) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
        CodecUtils.encodeHeaders(applicationHeaders, (ByteBuf)buf);
        return buf;
    }

    public static ByteBuf encodeHeadersJsonStyle(Map<String, String> applicationHeaders) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return Unpooled.wrappedBuffer((byte[])objectMapper.writeValueAsBytes(applicationHeaders));
    }
}

