/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.transport.tchannel;

import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.TFuture;
import com.uber.tchannel.api.errors.TChannelError;
import com.uber.tchannel.messages.JsonRequest;
import com.uber.tchannel.messages.JsonResponse;
import com.uber.tchannel.messages.RawRequest;
import com.uber.tchannel.messages.RawResponse;
import com.uber.tchannel.messages.ThriftRequest;
import com.uber.tchannel.messages.ThriftResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.exception.RPCException;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.ResponseListener;
import io.yarpc.util.HeaderUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TChannelOutbound
extends Outbound {
    private static final Logger logger = LoggerFactory.getLogger(TChannelOutbound.class);
    private final TChannel tchannel;
    private InetSocketAddress host;

    public TChannelOutbound(TChannel tchannel, String ip, int port) throws IOException {
        this.host = new InetSocketAddress(ip, port);
        this.tchannel = tchannel;
    }

    @Override
    public void send(Request<ByteBuffer> transportRequest, ResponseListener responseListener) throws RPCException {
        SubChannel subChannel = this.tchannel.makeSubChannel(transportRequest.getService());
        try {
            this.sendRequest(subChannel, transportRequest, responseListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }

    private void sendRequest(SubChannel subChannel, Request<ByteBuffer> transportRequest, ResponseListener responseListener) throws Exception {
        switch (transportRequest.getEncoding()) {
            case "json": {
                this.sendJsonRequest(subChannel, transportRequest, responseListener);
                break;
            }
            case "thrift": {
                this.sendThriftRequest(subChannel, transportRequest, responseListener);
                break;
            }
            case "raw": {
                this.sendRawRequest(subChannel, transportRequest, responseListener);
                break;
            }
            default: {
                throw new RPCException("Encoding type is not supported in TChannel protocol.");
            }
        }
    }

    private void sendThriftRequest(SubChannel subChannel, Request<ByteBuffer> transportRequest, ResponseListener responseListener) throws InterruptedException, ExecutionException, TChannelError {
        ThriftRequest req = new ThriftRequest.Builder(transportRequest.getService(), transportRequest.getProcedure()).setArg3(Unpooled.wrappedBuffer((ByteBuffer)transportRequest.getBody())).setHeaders(transportRequest.getHeaders()).setTimeout(transportRequest.getTimeout().getMillis()).build();
        TFuture future = subChannel.send(req, this.host.getAddress(), this.host.getPort());
        ThriftResponse response = (ThriftResponse)future.get();
        if (response.isError()) {
            Response<ByteBuffer> transportResponse = new Response.Builder().exception(new RPCException(response.getError().getMessage())).headers(response.getHeaders()).build();
            responseListener.onErrorReceived(transportResponse);
        } else {
            Response<ByteBuffer> transportResponse = new Response.Builder<ByteBuffer>().body(response.getArg3().nioBuffer()).headers(response.getHeaders()).build();
            responseListener.onResponseReceived(transportResponse);
        }
    }

    private void sendJsonRequest(SubChannel subChannel, Request<ByteBuffer> transportRequest, ResponseListener responseListener) throws InterruptedException, ExecutionException {
        JsonRequest req = new JsonRequest.Builder(transportRequest.getService(), transportRequest.getProcedure()).setArg3(Unpooled.wrappedBuffer((ByteBuffer)transportRequest.getBody())).setHeaders(transportRequest.getHeaders()).setTimeout(transportRequest.getTimeout().getMillis()).build();
        TFuture future = subChannel.send(req, this.host.getAddress(), this.host.getPort());
        JsonResponse response = (JsonResponse)future.get();
        if (response.isError()) {
            Response<ByteBuffer> transportResponse = new Response.Builder().exception(new RPCException(response.getError().getMessage())).headers(response.getHeaders()).build();
            responseListener.onErrorReceived(transportResponse);
        } else {
            Response<ByteBuffer> transportResponse = new Response.Builder<ByteBuffer>().body(response.getArg3().nioBuffer()).headers(response.getHeaders()).build();
            responseListener.onResponseReceived(transportResponse);
        }
    }

    private void sendRawRequest(SubChannel subChannel, Request<ByteBuffer> transportRequest, ResponseListener responseListener) throws InterruptedException, ExecutionException, IOException {
        RawRequest req = new RawRequest.Builder(transportRequest.getService(), transportRequest.getProcedure()).setArg3(Unpooled.wrappedBuffer((ByteBuffer)transportRequest.getBody())).setArg2(Unpooled.wrappedBuffer((ByteBuf)HeaderUtil.encodeHeaders(transportRequest.getHeaders()))).setTimeout(transportRequest.getTimeout().getMillis()).build();
        TFuture future = subChannel.send(req, this.host.getAddress(), this.host.getPort());
        RawResponse response = (RawResponse)future.get();
        if (response.isError()) {
            Response<ByteBuffer> transportResponse = new Response.Builder().exception(new RPCException(response.getError().getMessage())).headers(HeaderUtil.decodeHeaders(response.getArg2())).build();
            responseListener.onErrorReceived(transportResponse);
        } else {
            Response<ByteBuffer> transportResponse = new Response.Builder<ByteBuffer>().body(response.getArg3().nioBuffer()).headers(HeaderUtil.decodeHeaders(response.getArg2())).build();
            responseListener.onResponseReceived(transportResponse);
        }
    }
}

