/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.transport.tchannel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.uber.tchannel.api.handlers.RequestHandler;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.messages.RawResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.yarpc.HandlerRegistry;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.exception.RPCException;
import io.yarpc.handler.HandlerWrapper;
import io.yarpc.util.HeaderUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.joda.time.Duration;

public class TChannelInboundHandler
implements RequestHandler {
    private final HandlerRegistry handlerRegistry;

    public TChannelInboundHandler(HandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    private Request<ByteBuffer> parseRequest(com.uber.tchannel.messages.Request tchannelRequest) throws IOException {
        Map<String, String> headers = tchannelRequest.getArgScheme() == ArgScheme.JSON ? HeaderUtil.decodeHeadersJsonStyle(tchannelRequest.getArg2()) : HeaderUtil.decodeHeaders(tchannelRequest.getArg2());
        Request<ByteBuffer> transportRequest = new Request.Builder<ByteBuffer>().body(tchannelRequest.getArg3().nioBuffer()).headers(headers).procedure(tchannelRequest.getEndpoint()).service(tchannelRequest.getService()).timeout(new Duration(tchannelRequest.getTimeout())).build();
        return transportRequest;
    }

    public com.uber.tchannel.messages.Response handle(com.uber.tchannel.messages.Request request) {
        try {
            HandlerWrapper handlerWrapper = this.validateRequest(request);
            Request<ByteBuffer> transportRequest = this.parseRequest(request);
            Response<ByteBuffer> transportResponse = handlerWrapper.handle(transportRequest);
            ByteBuf headers = request.getArgScheme() == ArgScheme.JSON ? HeaderUtil.encodeHeadersJsonStyle(transportResponse.getHeaders()) : HeaderUtil.encodeHeaders(transportResponse.getHeaders());
            RawResponse response = new RawResponse.Builder(request).setArg2(headers).setArg3(Unpooled.wrappedBuffer((ByteBuffer)transportResponse.getBody())).build();
            return response;
        }
        catch (RPCException e) {
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HandlerWrapper validateRequest(com.uber.tchannel.messages.Request request) throws RPCException {
        String procedure = request.getEndpoint();
        HandlerWrapper handlerWrapper = this.handlerRegistry.lookupHandler(procedure);
        if (handlerWrapper == null) {
            throw new RPCException(String.format("Can't find handler for procedure: %s.", procedure));
        }
        return handlerWrapper;
    }
}

