/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.transport.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.TextHeaders;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.yarpc.HandlerRegistry;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.exception.RPCException;
import io.yarpc.handler.HandlerWrapper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServerInboundHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HTTPServerInboundHandler.class);
    private final HandlerRegistry handlerRegistry;

    public HTTPServerInboundHandler(HandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
    }

    protected void messageReceived(ChannelHandlerContext channelHandlerContext, FullHttpRequest httpRequest) throws Exception {
        HandlerWrapper handlerWrapper = this.validateRequest(httpRequest);
        this.forwardRequest(channelHandlerContext, httpRequest, handlerWrapper);
    }

    private Request<ByteBuffer> parseRequest(FullHttpRequest httpRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry entry : httpRequest.headers().entries()) {
            headers.put(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString());
        }
        HttpHeaders httpHeaders = httpRequest.headers();
        Request<ByteBuffer> transportRequest = new Request.Builder<ByteBuffer>().body(httpRequest.content().nioBuffer()).headers(headers).procedure(((CharSequence)httpHeaders.get((Object)"YARPC-Procedure")).toString()).service(((CharSequence)httpHeaders.get((Object)"YARPC-Service")).toString()).caller(((CharSequence)httpHeaders.get((Object)"YARPC-Caller")).toString()).timeout(new Duration((Object)Long.valueOf(((CharSequence)httpHeaders.get((Object)"YARPC-TTLms")).toString()))).build();
        return transportRequest;
    }

    private void forwardRequest(ChannelHandlerContext channelHandlerContext, FullHttpRequest httpRequest, HandlerWrapper handlerWrapper) throws RPCException {
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        Request<ByteBuffer> transportRequest = this.parseRequest(httpRequest);
        Response<ByteBuffer> transportResponse = handlerWrapper.handle(transportRequest);
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuffer)transportResponse.getBody()));
        Map<String, String> responseHeaders = transportResponse.getHeaders();
        for (Map.Entry<String, String> entry : responseHeaders.entrySet()) {
            httpHeaders.set((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(httpResponse.content().readableBytes()));
        httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE);
        httpResponse.headers().set((TextHeaders)httpHeaders);
        channelHandlerContext.writeAndFlush((Object)httpResponse);
        channelHandlerContext.channel().close();
        channelHandlerContext.close();
    }

    private HandlerWrapper validateRequest(FullHttpRequest rawRequest) throws RPCException {
        String procedure = ((CharSequence)rawRequest.headers().get((Object)"YARPC-Procedure")).toString();
        HandlerWrapper handlerWrapper = this.handlerRegistry.lookupHandler(procedure);
        if (handlerWrapper == null) {
            throw new RPCException(String.format("Can't find handler for procedure: %s.", procedure));
        }
        return handlerWrapper;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.warn("Unexpected exception occurs: {}", cause);
        ctx.channel().close();
        ctx.close();
    }
}

