/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.transport.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import io.yarpc.Request;
import io.yarpc.exception.RPCException;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.ResponseListener;
import io.yarpc.transport.http.HTTPClientInboundHandler;
import io.yarpc.transport.http.HTTPClientInitializer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPOutbound
extends Outbound {
    private static final Logger logger = LoggerFactory.getLogger(HTTPOutbound.class);
    private static final String PATH = "/yarpc/v1";
    private Bootstrap bootstrap;
    private InetSocketAddress host;
    private NioEventLoopGroup workerGroup = new NioEventLoopGroup();

    public HTTPOutbound(String ip, int port) throws IOException {
        this.host = new InetSocketAddress(ip, port);
        try {
            this.bootstrap = this.bootstrap((EventLoopGroup)this.workerGroup, new HTTPClientInitializer());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(Request<ByteBuffer> transportRequest, ResponseListener responseListener) throws RPCException {
        try {
            Channel channel = this.bootstrap.connect((SocketAddress)this.host).sync().channel();
            channel.pipeline().addLast("custom", (ChannelHandler)new HTTPClientInboundHandler(responseListener));
            this.sendRequest(channel, transportRequest);
            channel.closeFuture().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        catch (Exception e) {
            throw new RPCException(String.format("request failed due to: %s", e.getMessage()));
        }
    }

    @Override
    public void stop() {
        this.workerGroup.shutdownGracefully();
    }

    private void sendRequest(Channel channel, Request<ByteBuffer> transportRequest) throws Exception {
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, PATH);
        ByteBuf bbuf = Unpooled.wrappedBuffer((ByteBuffer)transportRequest.getBody());
        httpRequest.headers().add((CharSequence)"YARPC-Procedure", (CharSequence)transportRequest.getProcedure());
        httpRequest.headers().add((CharSequence)"encoding", (CharSequence)transportRequest.getEncoding());
        httpRequest.headers().add((CharSequence)"YARPC-TTLms", (CharSequence)String.valueOf(transportRequest.getTimeout().getMillis()));
        httpRequest.headers().add((CharSequence)"YARPC-Caller", (CharSequence)transportRequest.getCaller());
        httpRequest.headers().add((CharSequence)"YARPC-Service", (CharSequence)transportRequest.getService());
        httpRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(bbuf.readableBytes()));
        httpRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (CharSequence)this.host.getHostString());
        httpRequest.content().clear().writeBytes(bbuf);
        channel.writeAndFlush((Object)httpRequest);
    }

    private Bootstrap bootstrap(EventLoopGroup eventLoopGroup, HTTPClientInitializer httpClientInitializer) throws InterruptedException {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(eventLoopGroup);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)httpClientInitializer);
        return bootstrap;
    }
}

