/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.transport.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.yarpc.HandlerRegistry;
import io.yarpc.transport.Inbound;
import io.yarpc.transport.http.HTTPServerInitializer;
import java.util.concurrent.Future;

public class HTTPInbound
extends Inbound {
    private ServerBootstrap serverBootstrap;
    private int port;
    private HandlerRegistry handlerRegistry;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;

    public HTTPInbound(int port) {
        this.port = port;
    }

    public HTTPInbound(int port, HandlerRegistry handlerRegistry) {
        this.port = port;
        this.handlerRegistry = handlerRegistry;
    }

    @Override
    public void setHandlerRegistry(HandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    @Override
    public void stop() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }

    @Override
    public Future start() throws Exception {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.serverBootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HTTPServerInitializer(this.handlerRegistry)).option(ChannelOption.SO_BACKLOG, (Object)128);
        ChannelFuture f = this.serverBootstrap.bind(this.port).sync();
        return f.channel().closeFuture();
    }
}

