/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.transport.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.yarpc.Response;
import io.yarpc.context.ContextBuilder;
import io.yarpc.transport.ResponseListener;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClientInboundHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(HTTPClientInboundHandler.class);
    private final ResponseListener responseListener;

    public HTTPClientInboundHandler(ResponseListener responseListener) {
        this.responseListener = responseListener;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
    }

    protected void messageReceived(ChannelHandlerContext channelHandlerContext, FullHttpResponse httpResponse) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry entry : httpResponse.headers().entries()) {
            headers.put(((CharSequence)entry.getKey()).toString(), ((CharSequence)entry.getValue()).toString());
        }
        Response<ByteBuffer> transportResponse = new Response.Builder().headers(headers).context(ContextBuilder.build((HttpResponse)httpResponse)).body(httpResponse.content().nioBuffer()).build();
        this.responseListener.onResponseReceived(transportResponse);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.warn("Unexpected exception occurs: {}", (Object)cause.getMessage());
        ctx.close();
    }
}

