/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.handler;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.encoding.Serializer;
import io.yarpc.exception.RPCException;
import io.yarpc.handler.Handler;
import io.yarpc.handler.HandlerWrapper;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInboundHandler
implements HandlerWrapper {
    private static final Logger logger = LoggerFactory.getLogger(BaseInboundHandler.class);
    protected Serializer serializer;
    private Handler handler;
    private Class<?> requestBodyType;
    private Class<?> responseBodyType;

    public BaseInboundHandler(Serializer serializer, Handler handler) {
        this.parseHandler(handler);
        this.serializer = serializer;
    }

    @Override
    public Response<ByteBuffer> handle(Request<ByteBuffer> transportRequest) throws RPCException {
        this.validate(transportRequest);
        try {
            Request request = Request.fromByteBufferRequest(transportRequest, this.serializer, this.requestBodyType);
            Response response = this.getHandler().handle(request);
            return Response.toByteBufferResponse(response, this.serializer);
        }
        catch (Exception e) {
            throw new RPCException(e);
        }
    }

    public Class<?> getReqestBodyType() {
        return this.requestBodyType;
    }

    public Class<?> getResponseBodyType() {
        return this.responseBodyType;
    }

    private void parseHandler(Handler handler) {
        TypeResolver typeResolver = new TypeResolver();
        List types = typeResolver.resolve(handler.getClass(), new Type[0]).findSupertype(Handler.class).getTypeParameters();
        this.requestBodyType = ((ResolvedType)types.get(0)).getErasedType();
        this.responseBodyType = ((ResolvedType)types.get(1)).getErasedType();
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    protected void validate(Request<ByteBuffer> transportRequest) throws RPCException {
    }
}

