/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.thrift;

import io.yarpc.encoding.Serializer;
import io.yarpc.util.BufferUtil;
import java.nio.ByteBuffer;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ThriftSerializer
implements Serializer<TBase> {
    @Override
    public <T extends TBase> ByteBuffer marshal(T value) throws Exception {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        return ByteBuffer.wrap(serializer.serialize(value));
    }

    @Override
    public <T extends TBase> T unmarshal(ByteBuffer value, Class<T> clazz) throws Exception {
        TBase base = (TBase)clazz.newInstance();
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
        deserializer.deserialize(base, BufferUtil.toBytes(value));
        return (T)base;
    }
}

