/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.thrift;

import io.yarpc.RPC;
import io.yarpc.RPCFuture;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.config.Config;
import io.yarpc.encoding.thrift.ThriftClient;
import io.yarpc.encoding.thrift.ThriftInboundHandler;
import io.yarpc.exception.RPCException;
import io.yarpc.handler.Handler;
import io.yarpc.thrift.generated.KeyValue;
import io.yarpc.transport.Inbound;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.http.HTTPInbound;
import io.yarpc.transport.http.HTTPOutbound;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.Duration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ThriftIntegrationTest {
    private static final int httpPort = 9090;
    private static final String ip = "127.0.0.1";
    private static RPC rpc;

    @BeforeClass
    public static void setupServer() throws IOException {
        final Inbound httpInbound = ThriftIntegrationTest.setupHttpServer();
        final Outbound httpOutbound = ThriftIntegrationTest.setupHttpClient();
        rpc = new RPC(new Config("testServer", (List<Inbound>)new ArrayList<Inbound>(){
            {
                this.add(httpInbound);
            }
        }, (Map<String, Outbound>)new HashMap<String, Outbound>(){
            {
                this.put("testHttpServer", httpOutbound);
            }
        }));
        ThriftIntegrationTest.registerEndpoint();
        rpc.start();
    }

    private static Outbound setupHttpClient() throws IOException {
        return new HTTPOutbound(ip, 9090);
    }

    private static void registerEndpoint() {
        ThriftIntegrationTest.registerHttpEndpoint();
    }

    private static void registerHttpEndpoint() {
        ThriftInboundHandler getValueHandler = new ThriftInboundHandler(new Handler<KeyValue.getValue_args, KeyValue.getValue_result>(){

            @Override
            public Response<KeyValue.getValue_result> handle(Request<KeyValue.getValue_args> request) throws RPCException {
                return Response.Builder.forBody(new KeyValue.getValue_result(request.getBody().getKey(), null)).build();
            }
        });
        ThriftInboundHandler setValueHandler = new ThriftInboundHandler(new Handler<KeyValue.setValue_args, KeyValue.setValue_result>(){

            @Override
            public Response<KeyValue.setValue_result> handle(Request<KeyValue.setValue_args> request) throws RPCException {
                return Response.Builder.forBody(new KeyValue.setValue_result()).build();
            }
        });
        rpc.register("KeyValue::getValue", getValueHandler);
        rpc.register("KeyValue::setValue", setValueHandler);
    }

    public static Inbound setupHttpServer() {
        return new HTTPInbound(9090);
    }

    @AfterClass
    public static void shutdownHttpServer() {
        rpc.stop();
    }

    @Test
    public void httpTest() throws Exception {
        ThriftClient client = new ThriftClient(rpc);
        Request<Comparable<KeyValue.setValue_args>> request = new Request.Builder<KeyValue.setValue_args>().body(new KeyValue.setValue_args("language", "java")).service("testHttpServer").procedure("KeyValue::setValue").caller("testClient").timeout(Duration.millis((long)1000L)).build();
        RPCFuture<Response<KeyValue.setValue_result>> setValueFuture = client.call(request, KeyValue.setValue_result.class);
        setValueFuture.sync();
        request = new Request.Builder<KeyValue.getValue_args>().body(new KeyValue.getValue_args("language")).service("testHttpServer").procedure("KeyValue::getValue").caller("testClient").timeout(Duration.millis((long)1000L)).build();
        RPCFuture<Response<KeyValue.getValue_result>> getValueFuture = client.call(request, KeyValue.getValue_result.class);
        Response response = (Response)getValueFuture.get();
        Assert.assertEquals((Object)((KeyValue.getValue_result)response.getBody()).getSuccess(), (Object)"language");
    }
}

