/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.thrift;

import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.encoding.thrift.ThriftInboundHandler;
import io.yarpc.exception.RPCException;
import io.yarpc.handler.Handler;
import io.yarpc.thrift.generated.KeyValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThriftInboundHandlerTest {
    private ThriftInboundHandler thriftInboundHandler;

    @Before
    public void setup() {
        this.thriftInboundHandler = new ThriftInboundHandler(new Handler<KeyValue.getValue_args, KeyValue.getValue_result>(){

            @Override
            public Response<KeyValue.getValue_result> handle(Request<KeyValue.getValue_args> request) throws RPCException {
                return Response.Builder.forBody(new KeyValue.getValue_result("test", null)).build();
            }
        });
    }

    @Test
    public void testParseThriftHandler() {
        Assert.assertEquals(this.thriftInboundHandler.getResponseBodyType(), KeyValue.getValue_result.class);
        Assert.assertEquals(this.thriftInboundHandler.getReqestBodyType(), KeyValue.getValue_args.class);
    }

    @Test
    public void testEncoding() {
        Assert.assertEquals((Object)this.thriftInboundHandler.getEncoding(), (Object)"thrift");
    }
}

