/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.thrift;

import io.yarpc.RPC;
import io.yarpc.RPCClient;
import io.yarpc.RPCFuture;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.encoding.Serializer;
import io.yarpc.encoding.thrift.ThriftSerializer;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.ResponseListener;
import java.nio.ByteBuffer;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClient
extends RPCClient<TBase> {
    private static final Logger logger = LoggerFactory.getLogger(ThriftClient.class);
    private static final Serializer<TBase> serializer = new ThriftSerializer();
    private final RPC rpc;

    public ThriftClient(RPC rpc) {
        this.rpc = rpc;
    }

    @Override
    public <I extends TBase, O extends TBase> RPCFuture<Response<O>> call(Request<I> request, Class<O> responseBodyType) throws Exception {
        Outbound outbound = this.rpc.lookUpOutbound(request.getService());
        request.setEncoding("thrift");
        logger.debug(String.format("sending request %s", request.toString()));
        Request<ByteBuffer> transportRequest = Request.toByteBufferRequest(request, serializer);
        RPCFuture<Response<O>> rpcFuture = new RPCFuture<Response<O>>();
        outbound.send(transportRequest, new ThriftResponseListener(responseBodyType, rpcFuture));
        return rpcFuture;
    }

    private static class ThriftResponseListener<O extends TBase>
    implements ResponseListener {
        private final Class<O> responseBodyType;
        private final RPCFuture<Response<O>> rpcFuture;

        private ThriftResponseListener(Class<O> responseBodyType, RPCFuture<Response<O>> rpcFuture) {
            this.responseBodyType = responseBodyType;
            this.rpcFuture = rpcFuture;
        }

        @Override
        public void onResponseReceived(Response<ByteBuffer> transportResponse) {
            try {
                Response response = Response.fromByteBufferResponse(transportResponse, serializer, this.responseBodyType);
                this.rpcFuture.set(response);
            }
            catch (Exception e) {
                this.rpcFuture.setException(e);
            }
        }

        @Override
        public void onErrorReceived(Response<ByteBuffer> transportResponse) {
            this.rpcFuture.setException(transportResponse.getException());
        }
    }
}

