/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.raw;

import io.yarpc.RPC;
import io.yarpc.RPCFuture;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.config.Config;
import io.yarpc.encoding.raw.RawClient;
import io.yarpc.encoding.raw.RawInboundHandler;
import io.yarpc.handler.Handler;
import io.yarpc.transport.Inbound;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.http.HTTPInbound;
import io.yarpc.transport.http.HTTPOutbound;
import io.yarpc.util.BufferUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.Duration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RawIntegrationTest {
    private static final String respString = "apple";
    private static final int httpPort = 9090;
    private static final String ip = "127.0.0.1";
    private static RPC rpc;

    @BeforeClass
    public static void setupServer() throws IOException {
        final Inbound httpInbound = RawIntegrationTest.setupHttpServer();
        final Outbound httpOutbound = RawIntegrationTest.setupHttpClient();
        rpc = new RPC(new Config("testServer", (List<Inbound>)new ArrayList<Inbound>(){
            {
                this.add(httpInbound);
            }
        }, (Map<String, Outbound>)new HashMap<String, Outbound>(){
            {
                this.put("testHttpServer", httpOutbound);
            }
        }));
        RawIntegrationTest.registerEndpoint();
        rpc.start();
    }

    private static Outbound setupHttpClient() throws IOException {
        return new HTTPOutbound(ip, 9090);
    }

    private static void registerEndpoint() {
        RawIntegrationTest.registerHttpEndpoint();
    }

    private static void registerHttpEndpoint() {
        RawInboundHandler rawInboundHandler = new RawInboundHandler(new Handler<ByteBuffer, ByteBuffer>(){

            @Override
            public Response<ByteBuffer> handle(Request<ByteBuffer> request) {
                return Response.Builder.forBody(request.getBody()).build();
            }
        });
        rpc.register("testHttpEndpoint", rawInboundHandler);
    }

    public static Inbound setupHttpServer() {
        return new HTTPInbound(9090);
    }

    @AfterClass
    public static void shutdownHttpServer() {
        rpc.stop();
    }

    @Test
    public void httpTest() throws Exception {
        RawClient client = new RawClient(rpc);
        Request<ByteBuffer> request = new Request.Builder<ByteBuffer>().body(ByteBuffer.wrap(respString.getBytes())).service("testHttpServer").procedure("testHttpEndpoint").caller("testClient").timeout(Duration.millis((long)1000L)).build();
        RPCFuture<Response<ByteBuffer>> future = client.call(request);
        Response response = (Response)future.get();
        Assert.assertEquals((Object)new String(BufferUtil.toBytes((ByteBuffer)response.getBody())), (Object)respString);
    }
}

