/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.raw;

import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.encoding.raw.RawInboundHandler;
import io.yarpc.exception.RPCException;
import io.yarpc.handler.Handler;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RawInboundHandlerTest {
    private RawInboundHandler rawInboundHandler;

    @Before
    public void setup() {
        this.rawInboundHandler = new RawInboundHandler(new Handler<ByteBuffer, ByteBuffer>(){

            @Override
            public Response<ByteBuffer> handle(Request<ByteBuffer> request) throws RPCException {
                return Response.Builder.forBody(ByteBuffer.wrap("test".getBytes())).build();
            }
        });
    }

    @Test
    public void testParseThriftHandler() {
        Assert.assertEquals(this.rawInboundHandler.getResponseBodyType(), ByteBuffer.class);
        Assert.assertEquals(this.rawInboundHandler.getReqestBodyType(), ByteBuffer.class);
    }

    @Test
    public void testEncoding() {
        Assert.assertEquals((Object)this.rawInboundHandler.getEncoding(), (Object)"raw");
    }
}

