/*
 * Decompiled with CFR 0.152.
 */
package io.yarpc.encoding.raw;

import io.yarpc.RPC;
import io.yarpc.RPCClient;
import io.yarpc.RPCFuture;
import io.yarpc.Request;
import io.yarpc.Response;
import io.yarpc.encoding.Serializer;
import io.yarpc.encoding.raw.RawSerializer;
import io.yarpc.transport.Outbound;
import io.yarpc.transport.ResponseListener;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawClient
extends RPCClient<ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(RawClient.class);
    private static final Serializer<ByteBuffer> serializer = new RawSerializer();
    private final RPC rpc;

    public RawClient(RPC rpc) {
        this.rpc = rpc;
    }

    @Override
    public <I extends ByteBuffer, O extends ByteBuffer> RPCFuture<Response<O>> call(Request<I> request, Class<O> responseBodyType) throws Exception {
        Outbound outbound = this.rpc.lookUpOutbound(request.getService());
        request.setEncoding("raw");
        logger.debug(String.format("sending request %s", request.toString()));
        Request<ByteBuffer> transportRequest = Request.toByteBufferRequest(request, serializer);
        RPCFuture<Response<O>> rpcFuture = new RPCFuture<Response<O>>();
        outbound.send(transportRequest, new RawResponseListener(responseBodyType, rpcFuture));
        return rpcFuture;
    }

    @Override
    public <I extends ByteBuffer> RPCFuture<Response<I>> call(Request<I> request) throws Exception {
        return this.call(request, request.getGenericType());
    }

    private static class RawResponseListener<O extends ByteBuffer>
    implements ResponseListener {
        private final Class<O> responseBodyType;
        private final RPCFuture<Response<O>> rpcFuture;

        private RawResponseListener(Class<O> responseBodyType, RPCFuture<Response<O>> rpcFuture) {
            this.responseBodyType = responseBodyType;
            this.rpcFuture = rpcFuture;
        }

        @Override
        public void onResponseReceived(Response<ByteBuffer> transportResponse) {
            try {
                Response response = Response.fromByteBufferResponse(transportResponse, serializer, this.responseBodyType);
                this.rpcFuture.set(response);
            }
            catch (Exception e) {
                this.rpcFuture.setException(e);
            }
        }

        @Override
        public void onErrorReceived(Response<ByteBuffer> transportResponse) {
            this.rpcFuture.setException(transportResponse.getException());
        }
    }
}

